/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.parts.IAlphaPassItem;
import appeng.block.solids.OreQuartz;
import appeng.client.render.BusRenderer;
import appeng.core.FacadeConfig;
import appeng.core.features.AEFeature;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemFacade
extends AEBaseItem
implements IFacadeItem,
IAlphaPassItem {
    private List<ItemStack> subTypes = null;

    public ItemFacade() {
        this.setFeature(EnumSet.of(AEFeature.Facades));
        this.setHasSubtypes(true);
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)BusRenderer.INSTANCE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpriteNumber() {
        return 0;
    }

    public boolean onItemUse(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return AEApi.instance().partHelper().placeBus(is, x, y, z, side, player, w);
    }

    public String getItemStackDisplayName(ItemStack is) {
        try {
            ItemStack in = this.getTextureItem(is);
            if (in != null) {
                return super.getItemStackDisplayName(is) + " - " + in.getDisplayName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getItemStackDisplayName(is);
    }

    public void getSubItems(Item number, CreativeTabs tab, List list) {
        this.calculateSubTypes();
        list.addAll(this.subTypes);
    }

    private void calculateSubTypes() {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList<ItemStack>();
            for (Object blk : Block.blockRegistry) {
                Block b = (Block)blk;
                try {
                    Item item = Item.getItemFromBlock((Block)b);
                    ArrayList tmpList = new ArrayList();
                    b.getSubBlocks(item, b.getCreativeTabToDisplayOn(), tmpList);
                    for (ItemStack l : tmpList) {
                        ItemStack facade = this.createFacadeForItem(l, false);
                        if (facade == null) continue;
                        this.subTypes.add(facade);
                    }
                }
                catch (Throwable t) {
                }
            }
            if (FacadeConfig.instance.hasChanged()) {
                FacadeConfig.instance.save();
            }
        }
    }

    public ItemStack createFacadeForItem(ItemStack l, boolean returnItem) {
        boolean defaultValue;
        if (l == null) {
            return null;
        }
        Block b = Block.getBlockFromItem((Item)l.getItem());
        if (b == null || l.hasTagCompound()) {
            return null;
        }
        int metadata = l.getItem().getMetadata(l.getItemDamage());
        boolean hasTile = b.hasTileEntity(metadata);
        boolean enableGlass = b instanceof BlockGlass || b instanceof BlockStainedGlass;
        boolean disableOre = b instanceof OreQuartz;
        boolean bl = defaultValue = b.isOpaqueCube() && !b.getTickRandomly() && !hasTile && !disableOre || enableGlass;
        if (FacadeConfig.instance.checkEnabled(b, metadata, defaultValue)) {
            if (returnItem) {
                return l;
            }
            ItemStack is = new ItemStack((Item)this);
            NBTTagCompound data = new NBTTagCompound();
            int[] ds = new int[]{Item.getIdFromItem((Item)l.getItem()), metadata};
            data.setIntArray("x", ds);
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)l.getItem());
            data.setString("modid", ui.modId);
            data.setString("itemname", ui.name);
            is.setTagCompound(data);
            return is;
        }
        return null;
    }

    @Override
    public FacadePart createPartFromItemStack(ItemStack is, ForgeDirection side) {
        ItemStack in = this.getTextureItem(is);
        if (in != null) {
            return new FacadePart(is, side);
        }
        return null;
    }

    @Override
    public ItemStack getTextureItem(ItemStack is) {
        Block blk = this.getBlock(is);
        if (blk != null) {
            return new ItemStack(blk, 1, this.getMeta(is));
        }
        return null;
    }

    @Override
    public int getMeta(ItemStack is) {
        int[] blk;
        NBTTagCompound data = is.getTagCompound();
        if (data != null && (blk = data.getIntArray("x")) != null && blk.length == 2) {
            return blk[1];
        }
        return 0;
    }

    @Override
    public Block getBlock(ItemStack is) {
        NBTTagCompound data = is.getTagCompound();
        if (data != null) {
            if (data.hasKey("modid") && data.hasKey("itemname")) {
                return GameRegistry.findBlock((String)data.getString("modid"), (String)data.getString("itemname"));
            }
            int[] blk = data.getIntArray("x");
            if (blk != null && blk.length == 2) {
                return Block.getBlockById((int)blk[0]);
            }
        }
        return Blocks.glass;
    }

    public List<ItemStack> getFacades() {
        this.calculateSubTypes();
        return this.subTypes;
    }

    public ItemStack getCreativeTabIcon() {
        this.calculateSubTypes();
        if (this.subTypes.isEmpty()) {
            return new ItemStack(Items.cake);
        }
        return this.subTypes.get(0);
    }

    public ItemStack createFromIDs(int[] ids) {
        Iterator i$ = AEApi.instance().definitions().items().facade().maybeStack(1).asSet().iterator();
        if (i$.hasNext()) {
            ItemStack facadeStack = (ItemStack)i$.next();
            NBTTagCompound facadeTag = new NBTTagCompound();
            facadeTag.setIntArray("x", (int[])ids.clone());
            facadeStack.setTagCompound(facadeTag);
            return facadeStack;
        }
        throw new MissingDefinition("Tried to create a facade, while facades are being deactivated.");
    }

    @Override
    public boolean useAlphaPass(ItemStack is) {
        ItemStack out = this.getTextureItem(is);
        if (out == null || out.getItem() == null) {
            return false;
        }
        Block blk = Block.getBlockFromItem((Item)out.getItem());
        return blk != null && blk.canRenderInPass(1);
    }
}

