/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.contents;

import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.IGridHost;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class NetworkToolViewer
implements INetworkTool {
    final AppEngInternalInventory inv;
    final ItemStack is;
    final IGridHost gh;

    public NetworkToolViewer(ItemStack is, IGridHost gHost) {
        this.is = is;
        this.gh = gHost;
        this.inv = new AppEngInternalInventory(null, 9);
        if (is.hasTagCompound()) {
            this.inv.readFromNBT(Platform.openNbtData(is), "inv");
        }
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int i) {
        return this.inv.getStackInSlot(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        return this.inv.decrStackSize(i, j);
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return this.inv.getStackInSlotOnClosing(i);
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.inv.setInventorySlotContents(i, itemstack);
    }

    public String getInventoryName() {
        return this.inv.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        return this.inv.hasCustomInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inv.markDirty();
        this.inv.writeToNBT(Platform.openNbtData(this.is), "inv");
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.inv.isUseableByPlayer(entityplayer);
    }

    public void openInventory() {
        this.inv.openInventory();
    }

    public void closeInventory() {
        this.inv.closeInventory();
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return this.inv.isItemValidForSlot(i, itemstack) && itemstack.getItem() instanceof IUpgradeModule && ((IUpgradeModule)itemstack.getItem()).getType(itemstack) != null;
    }

    @Override
    public ItemStack getItemStack() {
        return this.is;
    }

    @Override
    public IGridHost getGridHost() {
        return this.gh;
    }
}

