/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.helpers;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.iterators.StackToSlotIterator;
import java.util.Iterator;
import net.mcft.copy.betterstorage.api.crate.ICrateStorage;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class BSCrateStorageAdaptor
extends InventoryAdaptor {
    final ICrateStorage cs;
    final ForgeDirection side;

    public BSCrateStorageAdaptor(Object te, ForgeDirection d) {
        this.cs = (ICrateStorage)te;
        this.side = d;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        ItemStack target = null;
        for (ItemStack is : this.cs.getContents()) {
            if (is == null || is.stackSize <= 0 || filter != null && !Platform.isSameItem(filter, is) || destination != null && !destination.canInsert(is)) continue;
            target = is;
            break;
        }
        if (target != null) {
            ItemStack f = Platform.cloneItemStack(target);
            f.stackSize = amount;
            return this.cs.extractItems(f, amount);
        }
        return null;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        ItemStack target = null;
        for (ItemStack is : this.cs.getContents()) {
            if (is == null || is.stackSize <= 0 || filter != null && !Platform.isSameItem(filter, is) || destination != null && !destination.canInsert(is)) continue;
            target = is;
            break;
        }
        if (target != null) {
            int cnt = this.cs.getItemCount(target);
            if (cnt == 0) {
                return null;
            }
            if (cnt > amount) {
                cnt = amount;
            }
            ItemStack c = target.copy();
            c.stackSize = cnt;
            return c;
        }
        return null;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemStack target = null;
        for (ItemStack is : this.cs.getContents()) {
            if (is == null || is.stackSize <= 0 || filter != null && !Platform.isSameItemFuzzy(filter, is, fuzzyMode) || destination != null && !destination.canInsert(is)) continue;
            target = is;
            break;
        }
        if (target != null) {
            ItemStack f = Platform.cloneItemStack(target);
            f.stackSize = amount;
            return this.cs.extractItems(f, amount);
        }
        return null;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemStack target = null;
        for (ItemStack is : this.cs.getContents()) {
            if (is == null || is.stackSize <= 0 || filter != null && !Platform.isSameItemFuzzy(filter, is, fuzzyMode) || destination != null && !destination.canInsert(is)) continue;
            target = is;
            break;
        }
        if (target != null) {
            int cnt = this.cs.getItemCount(target);
            if (cnt == 0) {
                return null;
            }
            if (cnt > amount) {
                cnt = amount;
            }
            ItemStack c = target.copy();
            c.stackSize = cnt;
            return c;
        }
        return null;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.cs.insertItems(toBeAdded);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        int items = this.cs.getSpaceForItem(toBeSimulated);
        ItemStack B = Platform.cloneItemStack(toBeSimulated);
        if (toBeSimulated.stackSize <= items) {
            return null;
        }
        B.stackSize -= items;
        return B;
    }

    @Override
    public boolean containsItems() {
        return this.cs.getUniqueItems() > 0;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new StackToSlotIterator(this.cs.getContents().iterator());
    }
}

