/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.definitions.ITileDefinition;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.core.AELog;
import appeng.integration.BaseModule;
import appeng.integration.abstraction.IImmibisMicroblocks;
import com.google.common.base.Optional;
import java.lang.reflect.Method;
import mods.immibis.core.api.multipart.ICoverSystem;
import mods.immibis.core.api.multipart.IMultipartTile;
import mods.immibis.core.api.multipart.IPartContainer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ImmibisMicroblocks
extends BaseModule
implements IImmibisMicroblocks {
    public static ImmibisMicroblocks INSTANCE;
    private boolean canConvertTiles = false;
    private Class<?> MicroblockAPIUtils;
    private Method mergeIntoMicroblockContainer;

    @Override
    public void init() throws Throwable {
        this.testClassExistence(IMultipartTile.class);
        this.testClassExistence(ICoverSystem.class);
        this.testClassExistence(IPartContainer.class);
        try {
            this.MicroblockAPIUtils = Class.forName("mods.immibis.microblocks.api.MicroblockAPIUtils");
            this.mergeIntoMicroblockContainer = this.MicroblockAPIUtils.getMethod("mergeIntoMicroblockContainer", ItemStack.class, EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Block.class, Integer.TYPE);
            this.canConvertTiles = true;
        }
        catch (Throwable t) {
            AELog.error(t);
        }
    }

    @Override
    public void postInit() {
    }

    @Override
    public IPartHost getOrCreateHost(EntityPlayer player, int side, TileEntity te) {
        TileEntity tx;
        boolean isPartItem;
        World w = te.getWorldObj();
        int x = te.xCoord;
        int y = te.yCoord;
        int z = te.zCoord;
        boolean bl = isPartItem = player != null && player.getHeldItem() != null && player.getHeldItem().getItem() instanceof IPartItem;
        if (te instanceof IMultipartTile && this.canConvertTiles && isPartItem) {
            boolean multiPartPresent;
            ITileDefinition multiPart = AEApi.instance().definitions().blocks().multiPart();
            Optional<Block> maybeMultiPartBlock = multiPart.maybeBlock();
            Optional<ItemStack> maybeMultiPartStack = multiPart.maybeStack(1);
            boolean bl2 = multiPartPresent = maybeMultiPartBlock.isPresent() && maybeMultiPartStack.isPresent();
            if (multiPartPresent) {
                Block multiPartBlock = (Block)maybeMultiPartBlock.get();
                ItemStack multiPartStack = (ItemStack)maybeMultiPartStack.get();
                try {
                    this.mergeIntoMicroblockContainer.invoke(null, multiPartStack, player, w, x, y, z, side, multiPartBlock, 0);
                }
                catch (Throwable e) {
                    this.canConvertTiles = false;
                    return null;
                }
            }
        }
        if ((tx = w.getTileEntity(x, y, z)) instanceof IPartHost) {
            return (IPartHost)tx;
        }
        return null;
    }

    @Override
    public boolean leaveParts(TileEntity te) {
        if (te instanceof IMultipartTile) {
            ICoverSystem ci = ((IMultipartTile)te).getCoverSystem();
            if (ci != null) {
                ci.convertToContainerBlock();
            }
            return true;
        }
        return false;
    }
}

