/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.parts.IPartHost;
import appeng.core.AELog;
import appeng.fmp.CableBusPart;
import appeng.fmp.FMPEvent;
import appeng.fmp.FMPPlacementHelper;
import appeng.fmp.PartRegistry;
import appeng.integration.IIntegrationModule;
import appeng.integration.abstraction.IFMP;
import appeng.integration.modules.helpers.FMPPacketEvent;
import appeng.parts.CableBusContainer;
import codechicken.lib.vec.BlockCoord;
import codechicken.microblock.BlockMicroMaterial;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.MultipartGenerator;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class FMP
implements IIntegrationModule,
MultiPartRegistry.IPartFactory,
MultiPartRegistry.IPartConverter,
IFMP {
    public static FMP instance;

    public TMultiPart createPart(String name, boolean client) {
        for (PartRegistry pr : PartRegistry.values()) {
            if (!pr.getName().equals(name)) continue;
            return pr.construct(0);
        }
        return null;
    }

    public TMultiPart convert(World world, BlockCoord pos) {
        int meta;
        Block blk = world.getBlock(pos.x, pos.y, pos.z);
        TMultiPart part = PartRegistry.getPartByBlock(blk, meta = world.getBlockMetadata(pos.x, pos.y, pos.z));
        if (part instanceof CableBusPart) {
            CableBusPart cbp = (CableBusPart)part;
            cbp.convertFromTile(world.getTileEntity(pos.x, pos.y, pos.z));
        }
        return part;
    }

    public Iterable<Block> blockTypes() {
        IBlocks blocks = AEApi.instance().definitions().blocks();
        ArrayList blockTypes = Lists.newArrayListWithCapacity((int)2);
        this.addBlockTypes(blockTypes, blocks.multiPart());
        this.addBlockTypes(blockTypes, blocks.quartzTorch());
        return blockTypes;
    }

    private void addBlockTypes(Collection<Block> blockTypes, IBlockDefinition definition) {
        for (Block block : definition.maybeBlock().asSet()) {
            blockTypes.add(block);
        }
    }

    @Override
    public void init() throws Throwable {
        IBlocks blocks = AEApi.instance().definitions().blocks();
        this.createAndRegister(blocks.quartz(), 0);
        this.createAndRegister(blocks.quartzPillar(), 0);
        this.createAndRegister(blocks.quartzChiseled(), 0);
        this.createAndRegister(blocks.skyStone(), 0);
        this.createAndRegister(blocks.skyStone(), 1);
        this.createAndRegister(blocks.skyStone(), 2);
        this.createAndRegister(blocks.skyStone(), 3);
        PartRegistry[] reg = PartRegistry.values();
        String[] data = new String[reg.length];
        for (int x = 0; x < data.length; ++x) {
            data[x] = reg[x].getName();
        }
        MultiPartRegistry.registerConverter((MultiPartRegistry.IPartConverter)this);
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)this, (String[])data);
        MultipartGenerator.registerPassThroughInterface((String)"appeng.helpers.AEMultiTile");
    }

    private void createAndRegister(IBlockDefinition definition, int i) {
        for (Block block : definition.maybeBlock().asSet()) {
            BlockMicroMaterial.createAndRegister((Block)block, (int)i);
        }
    }

    @Override
    public void postInit() {
        MinecraftForge.EVENT_BUS.register((Object)new FMPEvent());
    }

    @Override
    public IPartHost getOrCreateHost(TileEntity tile) {
        try {
            BlockCoord loc = new BlockCoord(tile.xCoord, tile.yCoord, tile.zCoord);
            TileMultipart mp = TileMultipart.getOrConvertTile((World)tile.getWorldObj(), (BlockCoord)loc);
            if (mp != null) {
                for (TMultiPart p : mp.partList()) {
                    if (!(p instanceof CableBusPart)) continue;
                    return (IPartHost)p;
                }
                return new FMPPlacementHelper(mp);
            }
        }
        catch (Throwable t) {
            AELog.error(t);
        }
        return null;
    }

    @Override
    public CableBusContainer getCableContainer(TileEntity te) {
        if (te instanceof TileMultipart) {
            TileMultipart mp = (TileMultipart)te;
            for (TMultiPart p : mp.partList()) {
                if (!(p instanceof CableBusPart)) continue;
                return ((CableBusPart)p).cb;
            }
        }
        return null;
    }

    @Override
    public void registerPassThrough(Class<?> layerInterface) {
        try {
            MultipartGenerator.registerPassThroughInterface((String)layerInterface.getName());
        }
        catch (Throwable t) {
            AELog.severe("Failed to register " + layerInterface.getName() + " with FMP, some features may not work with MultiParts.", new Object[0]);
            AELog.error(t);
        }
    }

    @Override
    public Event newFMPPacketEvent(EntityPlayerMP sender) {
        return new FMPPacketEvent(sender);
    }
}

