/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.implementations.tiles.ICrystalGrowthAccelerator;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public final class EntityGrowingCrystal
extends EntityItem {
    private int progress_1000 = 0;

    public EntityGrowingCrystal(World w) {
        super(w);
    }

    public EntityGrowingCrystal(World w, double x, double y, double z, ItemStack is) {
        super(w, x, y, z, is);
    }

    public void onUpdate() {
        ItemStack is;
        Item gc;
        super.onUpdate();
        if (!AEConfig.instance.isFeatureEnabled(AEFeature.inWorldPurification)) {
            return;
        }
        if (this.age > 600) {
            this.age = 100;
        }
        if ((gc = (is = this.getEntityItem()).getItem()) instanceof IGrowableCrystal) {
            int j = MathHelper.floor_double((double)this.posX);
            int i = MathHelper.floor_double((double)this.posY);
            int k = MathHelper.floor_double((double)this.posZ);
            Block blk = this.worldObj.getBlock(j, i, k);
            Material mat = blk.getMaterial();
            IGrowableCrystal cry = (IGrowableCrystal)is.getItem();
            float multiplier = cry.getMultiplier(blk, mat);
            int speed = (int)Math.max(1.0f, (float)this.getSpeed(j, i, k) * multiplier);
            boolean isClient = Platform.isClient();
            this.progress_1000 = mat.isLiquid() ? (isClient ? ++this.progress_1000 : (this.progress_1000 += speed)) : 0;
            if (isClient) {
                int len = 40;
                if (speed > 2) {
                    len = 20;
                }
                if (speed > 90) {
                    len = 15;
                }
                if (speed > 150) {
                    len = 10;
                }
                if (speed > 240) {
                    len = 7;
                }
                if (speed > 360) {
                    len = 3;
                }
                if (speed > 500) {
                    len = 1;
                }
                if (this.progress_1000 >= len) {
                    this.progress_1000 = 0;
                    CommonHelper.proxy.spawnEffect(EffectType.Vibrant, this.worldObj, this.posX, this.posY + 0.2, this.posZ, null);
                }
            } else if (this.progress_1000 > 1000) {
                this.progress_1000 -= 1000;
                this.setEntityItemStack(cry.triggerGrowth(is));
            }
        }
    }

    private int getSpeed(int x, int y, int z) {
        int per = 80;
        float mul = 0.3f;
        int qty = 0;
        if (this.isAccelerated(x + 1, y, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y + 1, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y, z + 1)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x - 1, y, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y - 1, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y, z - 1)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        return qty;
    }

    private boolean isAccelerated(int x, int y, int z) {
        TileEntity te = this.worldObj.getTileEntity(x, y, z);
        return te instanceof ICrystalGrowthAccelerator && ((ICrystalGrowthAccelerator)te).isPowered();
    }
}

