/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.GuiCraftConfirm;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.implementations.GuiNetworkStatus;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class PacketMEInventoryUpdate
extends AppEngPacket {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    private static final int OPERATION_BYTE_LIMIT = 2048;
    private static final int TEMP_BUFFER_SIZE = 1024;
    private static final int STREAM_MASK = 255;
    @Nullable
    private final List<IAEItemStack> list;
    private final byte ref;
    @Nullable
    private final ByteBuf data;
    @Nullable
    private final GZIPOutputStream compressFrame;
    private int writtenBytes = 0;
    private boolean empty = true;

    public PacketMEInventoryUpdate(final ByteBuf stream) throws IOException {
        this.data = null;
        this.compressFrame = null;
        this.list = new LinkedList<IAEItemStack>();
        this.ref = stream.readByte();
        GZIPInputStream gzReader = new GZIPInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                if (stream.readableBytes() <= 0) {
                    return -1;
                }
                return stream.readByte() & 0xFF;
            }
        });
        ByteBuf uncompressed = Unpooled.buffer((int)stream.readableBytes());
        byte[] tmp = new byte[1024];
        while (gzReader.available() != 0) {
            int bytes = gzReader.read(tmp);
            if (bytes <= 0) continue;
            uncompressed.writeBytes(tmp, 0, bytes);
        }
        gzReader.close();
        while (uncompressed.readableBytes() > 0) {
            this.list.add(AEItemStack.loadItemStackFromPacket(uncompressed));
        }
        this.empty = this.list.isEmpty();
    }

    public PacketMEInventoryUpdate() throws IOException {
        this(0);
    }

    public PacketMEInventoryUpdate(byte ref) throws IOException {
        this.ref = ref;
        this.data = Unpooled.buffer((int)2048);
        this.data.writeInt(this.getPacketID());
        this.data.writeByte((int)this.ref);
        this.compressFrame = new GZIPOutputStream(new OutputStream(){

            @Override
            public void write(int value) throws IOException {
                PacketMEInventoryUpdate.this.data.writeByte(value);
            }
        });
        this.list = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.getMinecraft().currentScreen;
        if (gs instanceof GuiCraftConfirm) {
            ((GuiCraftConfirm)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof GuiCraftingCPU) {
            ((GuiCraftingCPU)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof GuiMEMonitorable) {
            ((GuiMEMonitorable)gs).postUpdate(this.list);
        }
        if (gs instanceof GuiNetworkStatus) {
            ((GuiNetworkStatus)gs).postUpdate(this.list);
        }
    }

    @Override
    @Nullable
    public FMLProxyPacket getProxy() {
        try {
            this.compressFrame.close();
            this.configureWrite(this.data);
            return super.getProxy();
        }
        catch (IOException e) {
            AELog.error(e);
            return null;
        }
    }

    public void appendItem(IAEItemStack is) throws IOException, BufferOverflowException {
        ByteBuf tmp = Unpooled.buffer((int)2048);
        is.writeToPacket(tmp);
        this.compressFrame.flush();
        if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
            throw new BufferOverflowException();
        }
        this.writtenBytes += tmp.readableBytes();
        this.compressFrame.write(tmp.array(), 0, tmp.readableBytes());
        this.empty = false;
    }

    public int getLength() {
        return this.data.readableBytes();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

