/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.ToolNetworkTool;
import appeng.items.tools.powered.ToolColorApplicator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketClick
extends AppEngPacket {
    final int x;
    final int y;
    final int z;
    final int side;
    final float hitX;
    final float hitY;
    final float hitZ;

    public PacketClick(ByteBuf stream) {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        this.side = stream.readInt();
        this.hitX = stream.readFloat();
        this.hitY = stream.readFloat();
        this.hitZ = stream.readFloat();
    }

    public PacketClick(int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.x = x;
        data.writeInt(this.x);
        this.y = y;
        data.writeInt(this.y);
        this.z = z;
        data.writeInt(this.z);
        this.side = side;
        data.writeInt(this.side);
        this.hitX = hitX;
        data.writeFloat(this.hitX);
        this.hitY = hitY;
        data.writeFloat(this.hitY);
        this.hitZ = hitZ;
        data.writeFloat(this.hitZ);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ItemStack is = player.inventory.getCurrentItem();
        IItems items = AEApi.instance().definitions().items();
        IItemDefinition maybeMemoryCard = items.memoryCard();
        IItemDefinition maybeColorApplicator = items.colorApplicator();
        if (is != null) {
            if (is.getItem() instanceof ToolNetworkTool) {
                ToolNetworkTool tnt = (ToolNetworkTool)is.getItem();
                tnt.serverSideToolLogic(is, player, player.worldObj, this.x, this.y, this.z, this.side, this.hitX, this.hitY, this.hitZ);
            } else if (maybeMemoryCard.isSameAs(is)) {
                IMemoryCard mem = (IMemoryCard)is.getItem();
                mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
                is.setTagCompound(null);
            } else if (maybeColorApplicator.isSameAs(is)) {
                ToolColorApplicator mem = (ToolColorApplicator)is.getItem();
                mem.cycleColors(is, mem.getColor(is), 1);
            }
        }
    }
}

