/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.network;

import appeng.core.WorldSettings;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.AppEngClientPacketHandler;
import appeng.core.sync.network.AppEngServerPacketHandler;
import appeng.core.sync.network.IPacketHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public class NetworkHandler {
    public static NetworkHandler instance;
    final FMLEventChannel ec;
    final String myChannelName;
    final IPacketHandler clientHandler;
    final IPacketHandler serveHandler;

    public NetworkHandler(String channelName) {
        FMLCommonHandler.instance().bus().register((Object)this);
        this.myChannelName = channelName;
        this.ec = NetworkRegistry.INSTANCE.newEventDrivenChannel(this.myChannelName);
        this.ec.register((Object)this);
        this.clientHandler = this.createClientSide();
        this.serveHandler = this.createServerSide();
    }

    private IPacketHandler createClientSide() {
        try {
            return new AppEngClientPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private IPacketHandler createServerSide() {
        try {
            return new AppEngServerPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void newConnection(FMLNetworkEvent.ServerConnectionFromClientEvent ev) {
        WorldSettings.getInstance().sendToPlayer(ev.manager);
    }

    @SubscribeEvent
    public void newConnection(PlayerEvent.PlayerLoggedInEvent loginEvent) {
        if (loginEvent.player instanceof EntityPlayerMP) {
            WorldSettings.getInstance().sendToPlayer(null);
        }
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.packet.handler();
        if (this.serveHandler != null) {
            this.serveHandler.onPacketData(null, ev.packet, (EntityPlayer)srv.playerEntity);
        }
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        if (this.clientHandler != null) {
            this.clientHandler.onPacketData(null, ev.packet, null);
        }
    }

    public String getChannel() {
        return this.myChannelName;
    }

    public void sendToAll(AppEngPacket message) {
        this.ec.sendToAll(message.getProxy());
    }

    public void sendTo(AppEngPacket message, EntityPlayerMP player) {
        this.ec.sendTo(message.getProxy(), player);
    }

    public void sendToAllAround(AppEngPacket message, NetworkRegistry.TargetPoint point) {
        this.ec.sendToAllAround(message.getProxy(), point);
    }

    public void sendToDimension(AppEngPacket message, int dimensionId) {
        this.ec.sendToDimension(message.getProxy(), dimensionId);
    }

    public void sendToServer(AppEngPacket message) {
        this.ec.sendToServer(message.getProxy());
    }
}

