/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.SlotFakeTypeOnly;
import appeng.container.slot.SlotRestrictedInput;
import appeng.parts.automation.PartLevelEmitter;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class ContainerLevelEmitter
extends ContainerUpgradeable {
    final PartLevelEmitter lvlEmitter;
    @SideOnly(value=Side.CLIENT)
    public GuiTextField textField;
    @GuiSync(value=2)
    public LevelType lvType;
    @GuiSync(value=3)
    public long EmitterValue = -1L;
    @GuiSync(value=4)
    public YesNo cmType;

    public ContainerLevelEmitter(InventoryPlayer ip, PartLevelEmitter te) {
        super(ip, te);
        this.lvlEmitter = te;
    }

    @SideOnly(value=Side.CLIENT)
    public void setTextField(GuiTextField level) {
        this.textField = level;
        this.textField.setText(String.valueOf(this.EmitterValue));
    }

    public void setLevel(long l, EntityPlayer player) {
        this.lvlEmitter.setReportingValue(l);
        this.EmitterValue = l;
    }

    @Override
    protected void setupConfig() {
        int x = 124;
        int y = 40;
        IInventory upgrades = this.upgradeable.getInventoryByName("upgrades");
        if (this.availableUpgrades() > 0) {
            this.addSlotToContainer(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.invPlayer).setNotDraggable());
        }
        if (this.availableUpgrades() > 1) {
            this.addSlotToContainer(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.invPlayer).setNotDraggable());
        }
        if (this.availableUpgrades() > 2) {
            this.addSlotToContainer(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.invPlayer).setNotDraggable());
        }
        if (this.availableUpgrades() > 3) {
            this.addSlotToContainer(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.invPlayer).setNotDraggable());
        }
        IInventory inv = this.upgradeable.getInventoryByName("config");
        this.addSlotToContainer(new SlotFakeTypeOnly(inv, 0, x, y));
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void detectAndSendChanges() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.EmitterValue = this.lvlEmitter.getReportingValue();
            this.cmType = (YesNo)this.upgradeable.getConfigManager().getSetting(Settings.CRAFT_VIA_REDSTONE);
            this.lvType = (LevelType)this.upgradeable.getConfigManager().getSetting(Settings.LEVEL_TYPE);
            this.fzMode = (FuzzyMode)this.upgradeable.getConfigManager().getSetting(Settings.FUZZY_MODE);
            this.rsMode = (RedstoneMode)this.upgradeable.getConfigManager().getSetting(Settings.REDSTONE_EMITTER);
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("EmitterValue") && this.textField != null) {
            this.textField.setText(String.valueOf(this.EmitterValue));
        }
    }
}

