/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.CraftingCPURecord;
import appeng.core.AELog;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartTerminal;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ContainerCraftConfirm
extends AEBaseContainer {
    public final ArrayList<CraftingCPURecord> cpus = new ArrayList();
    final ITerminalHost priHost;
    public Future<ICraftingJob> job;
    public ICraftingJob result;
    @GuiSync(value=0)
    public long bytesUsed;
    @GuiSync(value=1)
    public long cpuBytesAvail;
    @GuiSync(value=2)
    public int cpuCoProcessors;
    @GuiSync(value=3)
    public boolean autoStart = false;
    @GuiSync(value=4)
    public boolean simulation = true;
    @GuiSync(value=5)
    public int selectedCpu = -1;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public String myName = "";
    protected long cpuIdx = Long.MIN_VALUE;

    public ContainerCraftConfirm(InventoryPlayer ip, ITerminalHost te) {
        super(ip, te);
        this.priHost = te;
    }

    public void cycleCpu(boolean next) {
        this.selectedCpu = next ? ++this.selectedCpu : --this.selectedCpu;
        if (this.selectedCpu < -1) {
            this.selectedCpu = this.cpus.size() - 1;
        } else if (this.selectedCpu >= this.cpus.size()) {
            this.selectedCpu = -1;
        }
        if (this.selectedCpu == -1) {
            this.cpuBytesAvail = 0L;
            this.cpuCoProcessors = 0;
            this.myName = "";
        } else {
            this.myName = this.cpus.get((int)this.selectedCpu).myName;
            this.cpuBytesAvail = this.cpus.get((int)this.selectedCpu).size;
            this.cpuCoProcessors = this.cpus.get((int)this.selectedCpu).processors;
        }
    }

    @Override
    public void detectAndSendChanges() {
        if (Platform.isClient()) {
            return;
        }
        ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
        ImmutableSet<ICraftingCPU> cpuSet = cc.getCpus();
        int matches = 0;
        boolean changed = false;
        for (ICraftingCPU c : cpuSet) {
            boolean found = false;
            for (CraftingCPURecord ccr : this.cpus) {
                if (ccr.cpu != c) continue;
                found = true;
            }
            boolean matched = this.cpuMatches(c);
            if (matched) {
                ++matches;
            }
            if (found != !matched) continue;
            changed = true;
        }
        if (changed || this.cpus.size() != matches) {
            this.cpus.clear();
            for (ICraftingCPU c : cpuSet) {
                if (!this.cpuMatches(c)) continue;
                this.cpus.add(new CraftingCPURecord(c.getAvailableStorage(), c.getCoProcessors(), c));
            }
            this.sendCPUs();
        }
        this.noCPU = this.cpus.size() == 0;
        super.detectAndSendChanges();
        if (this.job != null && this.job.isDone()) {
            try {
                this.result = this.job.get();
                if (!this.result.isSimulation()) {
                    this.simulation = false;
                    if (this.autoStart) {
                        this.startJob();
                        return;
                    }
                } else {
                    this.simulation = true;
                }
                try {
                    PacketMEInventoryUpdate a = new PacketMEInventoryUpdate(0);
                    PacketMEInventoryUpdate b = new PacketMEInventoryUpdate(1);
                    PacketMEInventoryUpdate c = this.result.isSimulation() ? new PacketMEInventoryUpdate(2) : null;
                    IItemList<IAEItemStack> plan = AEApi.instance().storage().createItemList();
                    this.result.populatePlan(plan);
                    this.bytesUsed = this.result.getByteTotal();
                    for (IAEItemStack out : plan) {
                        IAEItemStack m = null;
                        IAEItemStack o = out.copy();
                        o.reset();
                        o.setStackSize(out.getStackSize());
                        IAEItemStack p = out.copy();
                        p.reset();
                        p.setStackSize(out.getCountRequestable());
                        IStorageGrid sg = (IStorageGrid)this.getGrid().getCache(IStorageGrid.class);
                        IMEMonitor<IAEItemStack> items = sg.getItemInventory();
                        if (c != null && this.result.isSimulation()) {
                            m = o.copy();
                            if ((o = items.extractItems(o, Actionable.SIMULATE, this.mySrc)) == null) {
                                o = m.copy();
                                o.setStackSize(0L);
                            }
                            m.setStackSize(m.getStackSize() - o.getStackSize());
                        }
                        if (o.getStackSize() > 0L) {
                            a.appendItem(o);
                        }
                        if (p.getStackSize() > 0L) {
                            b.appendItem(p);
                        }
                        if (c == null || m == null || m.getStackSize() <= 0L) continue;
                        c.appendItem(m);
                    }
                    for (IAEItemStack g : this.crafters) {
                        if (!(g instanceof EntityPlayer)) continue;
                        NetworkHandler.instance.sendTo(a, (EntityPlayerMP)g);
                        NetworkHandler.instance.sendTo(b, (EntityPlayerMP)g);
                        if (c == null) continue;
                        NetworkHandler.instance.sendTo(c, (EntityPlayerMP)g);
                    }
                }
                catch (IOException e) {
                }
            }
            catch (Throwable e) {
                this.getPlayerInv().player.addChatMessage((IChatComponent)new ChatComponentText("Error: " + e.toString()));
                AELog.error(e);
                this.isContainerValid = false;
                this.result = null;
            }
            this.job = null;
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    public IGrid getGrid() {
        IActionHost h = (IActionHost)this.getTarget();
        return h.getActionableNode().getGrid();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.getAvailableStorage() >= this.bytesUsed && !c.isBusy();
    }

    private void sendCPUs() {
        Collections.sort(this.cpus);
        if (this.selectedCpu >= this.cpus.size()) {
            this.selectedCpu = -1;
            this.cpuBytesAvail = 0L;
            this.cpuCoProcessors = 0;
            this.myName = "";
        } else if (this.selectedCpu != -1) {
            this.myName = this.cpus.get((int)this.selectedCpu).myName;
            this.cpuBytesAvail = this.cpus.get((int)this.selectedCpu).size;
            this.cpuCoProcessors = this.cpus.get((int)this.selectedCpu).processors;
        }
    }

    public void startJob() {
        GuiBridge OriginalGui = null;
        IActionHost ah = this.getActionHost();
        if (ah instanceof WirelessTerminalGuiObject) {
            OriginalGui = GuiBridge.GUI_WIRELESS_TERM;
        }
        if (ah instanceof PartTerminal) {
            OriginalGui = GuiBridge.GUI_ME;
        }
        if (ah instanceof PartCraftingTerminal) {
            OriginalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (ah instanceof PartPatternTerminal) {
            OriginalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (this.result != null && !this.simulation) {
            ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
            ICraftingLink g = cc.submitJob(this.result, null, this.selectedCpu == -1 ? null : this.cpus.get((int)this.selectedCpu).cpu, true, this.getActionSrc());
            this.autoStart = false;
            if (g != null && OriginalGui != null && this.openContext != null) {
                NetworkHandler.instance.sendTo(new PacketSwitchGuis(OriginalGui), (EntityPlayerMP)this.invPlayer.player);
                TileEntity te = this.openContext.getTile();
                Platform.openGUI(this.invPlayer.player, te, this.openContext.side, OriginalGui);
            }
        }
    }

    public BaseActionSource getActionSrc() {
        return new PlayerSource(this.getPlayerInv().player, (IActionHost)this.getTarget());
    }

    public void removeCraftingFromCrafters(ICrafting c) {
        super.removeCraftingFromCrafters(c);
        if (this.job != null) {
            this.job.cancel(true);
            this.job = null;
        }
    }

    public void onContainerClosed(EntityPlayer par1EntityPlayer) {
        super.onContainerClosed(par1EntityPlayer);
        if (this.job != null) {
            this.job.cancel(true);
            this.job = null;
        }
    }

    public World getWorld() {
        return this.getPlayerInv().player.worldObj;
    }
}

