/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.client.texture.ExtraBlockTextures;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class EnergyFx
extends EntityBreakingFX {
    private final IIcon particleTextureIndex;
    private final int startBlkX;
    private final int startBlkY;
    private final int startBlkZ;

    public EnergyFx(World par1World, double par2, double par4, double par6, Item par8Item) {
        super(par1World, par2, par4, par6, par8Item);
        this.particleGravity = 0.0f;
        this.particleBlue = 255.0f;
        this.particleGreen = 255.0f;
        this.particleRed = 255.0f;
        this.particleAlpha = 1.4f;
        this.particleScale = 3.5f;
        this.particleTextureIndex = ExtraBlockTextures.BlockEnergyParticle.getIcon();
        this.startBlkX = MathHelper.floor_double((double)this.posX);
        this.startBlkY = MathHelper.floor_double((double)this.posY);
        this.startBlkZ = MathHelper.floor_double((double)this.posZ);
        this.noClip = true;
    }

    public int getFXLayer() {
        return 1;
    }

    public void renderParticle(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        float f6 = this.particleTextureIndex.getMinU();
        float f7 = this.particleTextureIndex.getMaxU();
        float f8 = this.particleTextureIndex.getMinV();
        float f9 = this.particleTextureIndex.getMaxV();
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)par2 - interpPosX);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)par2 - interpPosY);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)par2 - interpPosZ);
        float f14 = 1.0f;
        int blkX = MathHelper.floor_double((double)this.posX);
        int blkY = MathHelper.floor_double((double)this.posY);
        int blkZ = MathHelper.floor_double((double)this.posZ);
        if (blkX == this.startBlkX && blkY == this.startBlkY && blkZ == this.startBlkZ) {
            par1Tessellator.setColorRGBA_F(this.particleRed * f14, this.particleGreen * f14, this.particleBlue * f14, this.particleAlpha);
            par1Tessellator.addVertexWithUV((double)(f11 - par3 * f10 - par6 * f10), (double)(f12 - par4 * f10), (double)(f13 - par5 * f10 - par7 * f10), (double)f7, (double)f9);
            par1Tessellator.addVertexWithUV((double)(f11 - par3 * f10 + par6 * f10), (double)(f12 + par4 * f10), (double)(f13 - par5 * f10 + par7 * f10), (double)f7, (double)f8);
            par1Tessellator.addVertexWithUV((double)(f11 + par3 * f10 + par6 * f10), (double)(f12 + par4 * f10), (double)(f13 + par5 * f10 + par7 * f10), (double)f6, (double)f8);
            par1Tessellator.addVertexWithUV((double)(f11 + par3 * f10 - par6 * f10), (double)(f12 - par4 * f10), (double)(f13 + par5 * f10 - par7 * f10), (double)f6, (double)f9);
        }
    }

    public void fromItem(ForgeDirection d) {
        this.posX += 0.2 * (double)d.offsetX;
        this.posY += 0.2 * (double)d.offsetY;
        this.posZ += 0.2 * (double)d.offsetZ;
        this.particleScale *= 0.8f;
    }

    public void onUpdate() {
        super.onUpdate();
        this.particleScale *= 0.89f;
        this.particleAlpha *= 0.89f;
    }
}

