/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.EffectType;
import appeng.core.CommonHelper;
import appeng.entity.EntityFloatingItem;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class AssemblerFX
extends EntityFX {
    final IAEItemStack item;
    final EntityFloatingItem fi;
    final float speed;
    float time = 0.0f;

    public AssemblerFX(World w, double x, double y, double z, double r, double g, double b, float speed, IAEItemStack is) {
        super(w, x, y, z, r, g, b);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.item = is;
        this.speed = speed;
        this.fi = new EntityFloatingItem((Entity)this, w, x, y, z, is.getItemStack());
        w.spawnEntityInWorld((Entity)this.fi);
        this.particleMaxAge = (int)Math.ceil(Math.max(1.0f, 100.0f / speed)) + 2;
        this.noClip = true;
    }

    public int getBrightnessForRender(float par1) {
        int j1 = 13;
        return j1 << 20 | j1 << 4;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.isDead) {
            this.fi.setDead();
        } else {
            float lifeSpan = (float)this.particleAge / (float)this.particleMaxAge;
            this.fi.setProgress(lifeSpan);
        }
    }

    public void renderParticle(Tessellator tess, float l, float rX, float rY, float rZ, float rYZ, float rXY) {
        this.time += l;
        if ((double)this.time > 4.0) {
            this.time = (float)((double)this.time - 4.0);
            for (int x = 0; x < (int)Math.ceil(this.speed / 5.0f); ++x) {
                CommonHelper.proxy.spawnEffect(EffectType.Crafting, this.worldObj, this.posX, this.posY, this.posZ, null);
            }
        }
    }
}

