/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.slot.AppEngSlot;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class GuiPatternTerm
extends GuiMEMonitorable {
    final ContainerPatternTerm container;
    GuiTabButton tabCraftButton;
    GuiTabButton tabProcessButton;
    GuiImgButton encodeBtn;
    GuiImgButton clearBtn;

    public GuiPatternTerm(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(inventoryPlayer, te, new ContainerPatternTerm(inventoryPlayer, te));
        this.container = (ContainerPatternTerm)this.inventorySlots;
        this.reservedSpace = 81;
    }

    @Override
    protected void actionPerformed(GuiButton btn) {
        super.actionPerformed(btn);
        try {
            if (this.tabCraftButton == btn || this.tabProcessButton == btn) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("PatternTerminal.CraftMode", this.tabProcessButton == btn ? "1" : "0"));
            }
            if (this.encodeBtn == btn) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("PatternTerminal.Encode", "1"));
            }
            if (this.clearBtn == btn) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("PatternTerminal.Clear", "1"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.tabCraftButton = new GuiTabButton(this.guiLeft + 173, this.guiTop + this.ySize - 177, new ItemStack(Blocks.crafting_table), GuiText.CraftingPattern.getLocal(), itemRender);
        this.buttonList.add(this.tabCraftButton);
        this.tabProcessButton = new GuiTabButton(this.guiLeft + 173, this.guiTop + this.ySize - 177, new ItemStack(Blocks.furnace), GuiText.ProcessingPattern.getLocal(), itemRender);
        this.buttonList.add(this.tabProcessButton);
        this.clearBtn = new GuiImgButton(this.guiLeft + 74, this.guiTop + this.ySize - 163, Settings.ACTIONS, ActionItems.CLOSE);
        this.buttonList.add(this.clearBtn);
        this.clearBtn.halfSize = true;
        this.encodeBtn = new GuiImgButton(this.guiLeft + 147, this.guiTop + this.ySize - 142, Settings.ACTIONS, ActionItems.ENCODE);
        this.buttonList.add(this.encodeBtn);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (!this.container.craftingMode) {
            this.tabCraftButton.visible = false;
            this.tabProcessButton.visible = true;
        } else {
            this.tabCraftButton.visible = true;
            this.tabProcessButton.visible = false;
        }
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        this.fontRendererObj.drawString(GuiText.PatternTerminal.getLocal(), 8, this.ySize - 96 + 2 - this.reservedSpace, 0x404040);
    }

    @Override
    protected String getBackground() {
        if (this.container.craftingMode) {
            return "guis/pattern.png";
        }
        return "guis/pattern2.png";
    }

    @Override
    protected void repositionSlot(AppEngSlot s) {
        s.yDisplayPosition = s.isPlayerSide() ? s.defY + this.ySize - 78 - 5 : s.defY + this.ySize - 78 - 3;
    }
}

