/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.me.SlotME;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class AEBaseMEGui
extends AEBaseGui {
    public AEBaseMEGui(Container container) {
        super(container);
    }

    public List<String> handleItemTooltip(ItemStack stack, int mouseX, int mouseY, List<String> currentToolTip) {
        Slot s;
        if (stack != null && (s = this.getSlot(mouseX, mouseY)) instanceof SlotME) {
            String local;
            int BigNumber = AEConfig.instance.useTerminalUseLargeFont() ? 999 : 9999;
            IAEItemStack myStack = null;
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (myStack != null) {
                String format;
                String formattedAmount;
                if (myStack.getStackSize() > (long)BigNumber || myStack.getStackSize() > 1L && stack.isItemDamaged()) {
                    local = ButtonToolTips.ItemsStored.getLocal();
                    formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(myStack.getStackSize());
                    format = String.format(local, formattedAmount);
                    currentToolTip.add("\u00a77" + format);
                }
                if (myStack.getCountRequestable() > 0L) {
                    local = ButtonToolTips.ItemsRequestable.getLocal();
                    formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(myStack.getCountRequestable());
                    format = String.format(local, formattedAmount);
                    currentToolTip.add("\u00a77" + format);
                }
            } else if (stack.stackSize > BigNumber || stack.stackSize > 1 && stack.isItemDamaged()) {
                local = ButtonToolTips.ItemsStored.getLocal();
                String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(stack.stackSize);
                String format = String.format(local, formattedAmount);
                currentToolTip.add("\u00a77" + format);
            }
        }
        return currentToolTip;
    }

    protected void renderToolTip(ItemStack stack, int x, int y) {
        Slot s = this.getSlot(x, y);
        if (s instanceof SlotME && stack != null) {
            int BigNumber = AEConfig.instance.useTerminalUseLargeFont() ? 999 : 9999;
            IAEItemStack myStack = null;
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (myStack != null) {
                List currentToolTip = stack.getTooltip((EntityPlayer)this.mc.thePlayer, this.mc.gameSettings.advancedItemTooltips);
                if (myStack.getStackSize() > (long)BigNumber || myStack.getStackSize() > 1L && stack.isItemDamaged()) {
                    currentToolTip.add("Items Stored: " + NumberFormat.getNumberInstance(Locale.US).format(myStack.getStackSize()));
                }
                if (myStack.getCountRequestable() > 0L) {
                    currentToolTip.add("Items Requestable: " + NumberFormat.getNumberInstance(Locale.US).format(myStack.getCountRequestable()));
                }
                this.drawTooltip(x, y, 0, AEBaseMEGui.join(currentToolTip, "\n"));
            } else if (stack.stackSize > BigNumber) {
                List var4 = stack.getTooltip((EntityPlayer)this.mc.thePlayer, this.mc.gameSettings.advancedItemTooltips);
                var4.add("Items Stored: " + NumberFormat.getNumberInstance(Locale.US).format(stack.stackSize));
                this.drawTooltip(x, y, 0, AEBaseMEGui.join(var4, "\n"));
                return;
            }
        }
        super.renderToolTip(stack, x, y);
    }
}

