/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.solids;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderQuartzOre;
import appeng.core.features.AEFeature;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class OreQuartz
extends AEBaseBlock {
    private int boostBrightnessLow;
    private int boostBrightnessHigh;
    private boolean enhanceBrightness;

    public OreQuartz() {
        this(OreQuartz.class);
    }

    public OreQuartz(Class<? extends OreQuartz> self) {
        super(self, Material.rock);
        this.setHardness(3.0f);
        this.setResistance(5.0f);
        this.boostBrightnessLow = 0;
        this.boostBrightnessHigh = 1;
        this.enhanceBrightness = false;
        this.setFeature(EnumSet.of(AEFeature.Core));
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderQuartzOre.class;
    }

    @Override
    public void postInit() {
        OreDictionary.registerOre((String)"oreCertusQuartz", (ItemStack)new ItemStack((Block)this));
    }

    public int getMixedBrightnessForBlock(IBlockAccess par1iBlockAccess, int par2, int par3, int par4) {
        int j1 = super.getMixedBrightnessForBlock(par1iBlockAccess, par2, par3, par4);
        if (this.enhanceBrightness) {
            j1 = (j1 = Math.max(j1 >> 20, j1 >> 4)) > 4 ? (j1 += this.boostBrightnessHigh) : (j1 += this.boostBrightnessLow);
            if (j1 > 15) {
                j1 = 15;
            }
            return j1 << 20 | j1 << 4;
        }
        return j1;
    }

    public int quantityDropped(Random rand) {
        return 1 + rand.nextInt(2);
    }

    @Nullable
    public Item getItemDropped(int id, Random rand, int meta) {
        Iterator i$ = AEApi.instance().definitions().materials().certusQuartzCrystal().maybeItem().asSet().iterator();
        if (i$.hasNext()) {
            Item crystalItem = (Item)i$.next();
            return crystalItem;
        }
        throw new MissingDefinition("Tried to access certus quartz crystal, even though they are disabled");
    }

    public void dropBlockAsItemWithChance(World w, int x, int y, int z, int blockID, float something, int meta) {
        super.dropBlockAsItemWithChance(w, x, y, z, blockID, something, meta);
        if (this.getItemDropped(blockID, w.rand, meta) != Item.getItemFromBlock((Block)this)) {
            int xp = MathHelper.getRandomIntegerInRange((Random)w.rand, (int)2, (int)5);
            this.dropXpOnBlockBreak(w, x, y, z, xp);
        }
    }

    public int damageDropped(int id) {
        Iterator i$ = AEApi.instance().definitions().materials().certusQuartzCrystal().maybeStack(1).asSet().iterator();
        if (i$.hasNext()) {
            ItemStack crystalStack = (ItemStack)i$.next();
            return crystalStack.getItemDamage();
        }
        throw new MissingDefinition("Tried to access certus quartz crystal, even though they are disabled");
    }

    public int quantityDroppedWithBonus(int fortune, Random rand) {
        if (fortune > 0 && Item.getItemFromBlock((Block)this) != this.getItemDropped(0, rand, fortune)) {
            int j = rand.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return this.quantityDropped(rand) * (j + 1);
        }
        return this.quantityDropped(rand);
    }

    public void setBoostBrightnessLow(int boostBrightnessLow) {
        this.boostBrightnessLow = boostBrightnessLow;
    }

    public void setBoostBrightnessHigh(int boostBrightnessHigh) {
        this.boostBrightnessHigh = boostBrightnessHigh;
    }

    public void setEnhanceBrightness(boolean enhanceBrightness) {
        this.enhanceBrightness = enhanceBrightness;
    }
}

