/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.qnb;

import appeng.block.AEBaseBlock;
import appeng.client.EffectType;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderQNB;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.qnb.TileQuantumBridge;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockQuantumLinkChamber
extends AEBaseBlock
implements ICustomCollision {
    public BlockQuantumLinkChamber() {
        super(BlockQuantumLinkChamber.class, AEGlassMaterial.INSTANCE);
        this.setTileEntity(TileQuantumBridge.class);
        float shave = 0.125f;
        this.setBlockBounds(shave, shave, shave, 1.0f - shave, 1.0f - shave, 1.0f - shave);
        this.setLightOpacity(0);
        this.isOpaque = false;
        this.isFullSize = false;
        this.setFeature(EnumSet.of(AEFeature.QuantumNetworkBridge));
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int bx, int by, int bz, Random r) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, bx, by, bz);
        if (bridge != null && bridge.hasQES() && CommonHelper.proxy.shouldAddParticles(r)) {
            CommonHelper.proxy.spawnEffect(EffectType.Energy, w, (double)bx + 0.5, (double)by + 0.5, (double)bz + 0.5, null);
        }
    }

    public void onNeighborBlockChange(World w, int x, int y, int z, Block pointlessNumber) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (bridge != null) {
            bridge.neighborUpdate();
        }
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderQNB.class;
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        if (p.isSneaking()) {
            return false;
        }
        TileQuantumBridge tg = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tg != null) {
            if (Platform.isServer()) {
                Platform.openGUI(p, tg, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_QNB);
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World w, int x, int y, int z, Block a, int b) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (bridge != null) {
            bridge.breakCluster();
        }
        super.breakBlock(w, x, y, z, a, b);
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        double OnePx = 0.125;
        return Collections.singletonList(AxisAlignedBB.getBoundingBox((double)OnePx, (double)OnePx, (double)OnePx, (double)(1.0 - OnePx), (double)(1.0 - OnePx), (double)(1.0 - OnePx)));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        double OnePx = 0.125;
        out.add(AxisAlignedBB.getBoundingBox((double)OnePx, (double)OnePx, (double)OnePx, (double)(1.0 - OnePx), (double)(1.0 - OnePx), (double)(1.0 - OnePx)));
    }
}

