/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderQuartzTorch;
import appeng.client.render.effects.LightningFX;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.helpers.ICustomCollision;
import appeng.helpers.MetaRotation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockQuartzTorch
extends AEBaseBlock
implements IOrientableBlock,
ICustomCollision {
    public BlockQuartzTorch() {
        this(BlockQuartzTorch.class);
        this.setLightLevel(0.9375f);
        this.setFeature(EnumSet.of(AEFeature.DecorativeLights));
    }

    protected BlockQuartzTorch(Class which) {
        super(which, Material.circuits);
        this.setLightOpacity(0);
        this.isOpaque = false;
        this.isFullSize = false;
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderQuartzTorch.class;
    }

    @Override
    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        return this.canPlaceAt(w, x, y, z, up.getOpposite());
    }

    private boolean canPlaceAt(World w, int x, int y, int z, ForgeDirection dir) {
        return w.isSideSolid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite(), false);
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        ForgeDirection up = this.getOrientable((IBlockAccess)w, x, y, z).getUp();
        double xOff = -0.3 * (double)up.offsetX;
        double yOff = -0.3 * (double)up.offsetY;
        double zOff = -0.3 * (double)up.offsetZ;
        return Collections.singletonList(AxisAlignedBB.getBoundingBox((double)(xOff + 0.3), (double)(yOff + 0.3), (double)(zOff + 0.3), (double)(xOff + 0.7), (double)(yOff + 0.7), (double)(zOff + 0.7)));
    }

    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int x, int y, int z, Random r) {
        if (!AEConfig.instance.enableEffects) {
            return;
        }
        if ((double)r.nextFloat() < 0.98) {
            return;
        }
        ForgeDirection up = this.getOrientable((IBlockAccess)w, x, y, z).getUp();
        double xOff = -0.3 * (double)up.offsetX;
        double yOff = -0.3 * (double)up.offsetY;
        double zOff = -0.3 * (double)up.offsetZ;
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (!CommonHelper.proxy.shouldAddParticles(r)) continue;
            LightningFX fx = new LightningFX(w, xOff + 0.5 + (double)x, yOff + 0.5 + (double)y, zOff + 0.5 + (double)z, 0.0, 0.0, 0.0);
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
        }
    }

    public void onNeighborBlockChange(World w, int x, int y, int z, Block id) {
        ForgeDirection up = this.getOrientable((IBlockAccess)w, x, y, z).getUp();
        if (!this.canPlaceAt(w, x, y, z, up.getOpposite())) {
            this.dropTorch(w, x, y, z);
        }
    }

    private void dropTorch(World w, int x, int y, int z) {
        w.func_147480_a(x, y, z, true);
        w.markBlockForUpdate(x, y, z);
    }

    public boolean canPlaceBlockAt(World w, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.canPlaceAt(w, x, y, z, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean usesMetadata() {
        return true;
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        return new MetaRotation(w, x, y, z);
    }
}

