/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.misc.BlockQuartzTorch;
import appeng.core.features.AEFeature;
import appeng.tile.misc.TileLightDetector;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLightDetector
extends BlockQuartzTorch {
    public BlockLightDetector() {
        super(BlockLightDetector.class);
        this.setTileEntity(TileLightDetector.class);
        this.setFeature(EnumSet.of(AEFeature.LightDetector));
    }

    public int isProvidingWeakPower(IBlockAccess w, int x, int y, int z, int side) {
        if (w instanceof World && ((TileLightDetector)this.getTileEntity(w, x, y, z)).isReady()) {
            return ((World)w).getBlockLightValue(x, y, z) - 6;
        }
        return 0;
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        super.onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
        TileLightDetector tld = (TileLightDetector)this.getTileEntity(world, x, y, z);
        if (tld != null) {
            tld.updateLight();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int x, int y, int z, Random r) {
    }
}

