/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderBlockCraftingCPU;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.tile.crafting.TileCraftingTile;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCraftingUnit
extends AEBaseBlock {
    public static final int FLAG_FORMED = 8;

    public BlockCraftingUnit() {
        this(BlockCraftingUnit.class);
        this.setTileEntity(TileCraftingTile.class);
    }

    public BlockCraftingUnit(Class<? extends BlockCraftingUnit> childClass) {
        super(childClass, Material.iron);
        this.hasSubtypes = true;
        this.setFeature(EnumSet.of(AEFeature.CraftingCPU));
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderBlockCraftingCPU.class;
    }

    @Override
    public IIcon getIcon(int direction, int metadata) {
        switch (metadata) {
            default: {
                return super.getIcon(0, 0);
            }
            case 1: {
                return ExtraBlockTextures.BlockCraftingAccelerator.getIcon();
            }
            case 8: {
                return ExtraBlockTextures.BlockCraftingUnitFit.getIcon();
            }
            case 9: 
        }
        return ExtraBlockTextures.BlockCraftingAcceleratorFit.getIcon();
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        TileCraftingTile tg = (TileCraftingTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tg != null && !p.isSneaking() && tg.isFormed() && tg.isActive()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(p, tg, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_CRAFTING_CPU);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        itemStacks.add(new ItemStack((Block)this, 1, 0));
        itemStacks.add(new ItemStack((Block)this, 1, 1));
    }

    @Override
    public void setRenderStateByMeta(int itemDamage) {
        IIcon front = this.getIcon(ForgeDirection.SOUTH.ordinal(), itemDamage);
        IIcon other = this.getIcon(ForgeDirection.NORTH.ordinal(), itemDamage);
        this.getRendererInstance().setTemporaryRenderIcons(other, other, front, other, other, other);
    }

    @Override
    public void breakBlock(World w, int x, int y, int z, Block a, int b) {
        TileCraftingTile cp = (TileCraftingTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (cp != null) {
            cp.breakCluster();
        }
        super.breakBlock(w, x, y, z, a, b);
    }

    @Override
    public String getUnlocalizedName(ItemStack is) {
        if (is.getItemDamage() == 1) {
            return "tile.appliedenergistics2.BlockCraftingAccelerator";
        }
        return this.getItemUnlocalizedName(is);
    }

    protected String getItemUnlocalizedName(ItemStack is) {
        return super.getUnlocalizedName(is);
    }

    public void onNeighborBlockChange(World w, int x, int y, int z, Block junk) {
        TileCraftingTile cp = (TileCraftingTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (cp != null) {
            cp.updateMultiBlock();
        }
    }

    public int damageDropped(int meta) {
        return meta & 3;
    }

    public int getDamageValue(World w, int x, int y, int z) {
        int meta = w.getBlockMetadata(x, y, z);
        return this.damageDropped(meta);
    }
}

