/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.client.texture.CableBusTextures;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.OffsetIcon;
import appeng.client.texture.TaughtIcon;
import appeng.parts.networking.PartCable;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PartDenseCable
extends PartCable {
    public PartDenseCable(ItemStack is) {
        super(is);
        this.getProxy().setFlags(GridFlags.DENSE_CAPACITY, GridFlags.PREFERRED);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.DENSE_CABLE;
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.DENSE;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean noLadder = !bch.isBBCollision();
        double min = noLadder ? 3.0 : 4.9;
        double max = noLadder ? 13.0 : 11.1;
        bch.addBox(min, min, min, max, max, max);
        if (Platform.isServer()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.setConnections(n.getConnectedSides());
            } else {
                this.getConnections().clear();
            }
        }
        block16: for (ForgeDirection of : this.getConnections()) {
            if (this.isDense(of)) {
                switch (of) {
                    case DOWN: {
                        bch.addBox(min, 0.0, min, max, min, max);
                        continue block16;
                    }
                    case EAST: {
                        bch.addBox(max, min, min, 16.0, max, max);
                        continue block16;
                    }
                    case NORTH: {
                        bch.addBox(min, min, 0.0, max, max, min);
                        continue block16;
                    }
                    case SOUTH: {
                        bch.addBox(min, min, max, max, max, 16.0);
                        continue block16;
                    }
                    case UP: {
                        bch.addBox(min, max, min, max, 16.0, max);
                        continue block16;
                    }
                    case WEST: {
                        bch.addBox(0.0, min, min, min, max, max);
                        continue block16;
                    }
                }
                continue;
            }
            switch (of) {
                case DOWN: {
                    bch.addBox(5.0, 0.0, 5.0, 11.0, 5.0, 11.0);
                    break;
                }
                case EAST: {
                    bch.addBox(11.0, 5.0, 5.0, 16.0, 11.0, 11.0);
                    break;
                }
                case NORTH: {
                    bch.addBox(5.0, 5.0, 0.0, 11.0, 11.0, 5.0);
                    break;
                }
                case SOUTH: {
                    bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 16.0);
                    break;
                }
                case UP: {
                    bch.addBox(5.0, 11.0, 5.0, 11.0, 16.0, 11.0);
                    break;
                }
                case WEST: {
                    bch.addBox(0.0, 5.0, 5.0, 5.0, 11.0, 11.0);
                    break;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        GL11.glTranslated((double)-0.0, (double)-0.0, (double)0.3);
        rh.setBounds(4.0f, 4.0f, 2.0f, 12.0f, 12.0f, 14.0f);
        float offU = 0.0f;
        float offV = 9.0f;
        OffsetIcon main = new OffsetIcon(this.getTexture(this.getCableColor()), offU, offV);
        OffsetIcon ch1 = new OffsetIcon(this.getChannelTex(4, false).getIcon(), offU, offV);
        OffsetIcon ch2 = new OffsetIcon(this.getChannelTex(4, true).getIcon(), offU, offV);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.UP, ForgeDirection.DOWN)) {
            rh.renderInventoryFace(main, side, renderer);
            rh.renderInventoryFace(ch1, side, renderer);
            rh.renderInventoryFace(ch2, side, renderer);
        }
        offU = 9.0f;
        offV = 0.0f;
        main = new OffsetIcon(this.getTexture(this.getCableColor()), offU, offV);
        ch1 = new OffsetIcon(this.getChannelTex(4, false).getIcon(), offU, offV);
        ch2 = new OffsetIcon(this.getChannelTex(4, true).getIcon(), offU, offV);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.EAST, ForgeDirection.WEST)) {
            rh.renderInventoryFace(main, side, renderer);
            rh.renderInventoryFace(ch1, side, renderer);
            rh.renderInventoryFace(ch2, side, renderer);
        }
        main = new OffsetIcon(this.getTexture(this.getCableColor()), 0.0f, 0.0f);
        ch1 = new OffsetIcon(this.getChannelTex(4, false).getIcon(), 0.0f, 0.0f);
        ch2 = new OffsetIcon(this.getChannelTex(4, true).getIcon(), 0.0f, 0.0f);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.SOUTH, ForgeDirection.NORTH)) {
            rh.renderInventoryFace(main, side, renderer);
            rh.renderInventoryFace(ch1, side, renderer);
            rh.renderInventoryFace(ch2, side, renderer);
        }
        rh.setTexture(null);
    }

    @Override
    public IIcon getTexture(AEColor c) {
        if (c == AEColor.Transparent) {
            return AEApi.instance().definitions().parts().cableSmart().stack(AEColor.Transparent, 1).func_77954_c();
        }
        return this.getSmartTexture(c);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, this, this.getRenderCache()));
        rh.setTexture(this.getTexture(this.getCableColor()));
        Object sides = this.getConnections().clone();
        boolean hasBuses = false;
        for (ForgeDirection forgeDirection : this.getConnections()) {
            if (this.isDense(forgeDirection)) continue;
            hasBuses = true;
        }
        if (((AbstractCollection)sides).size() != 2 || !this.nonLinear((EnumSet<ForgeDirection>)sides) || hasBuses) {
            for (ForgeDirection forgeDirection : this.getConnections()) {
                if (this.isDense(forgeDirection)) {
                    this.renderDenseConnection(x, y, z, rh, renderer, this.getChannelsOnSide()[forgeDirection.ordinal()], forgeDirection);
                    continue;
                }
                if (this.isSmart(forgeDirection)) {
                    this.renderSmartConnection(x, y, z, rh, renderer, this.getChannelsOnSide()[forgeDirection.ordinal()], forgeDirection);
                    continue;
                }
                this.renderCoveredConnection(x, y, z, rh, renderer, this.getChannelsOnSide()[forgeDirection.ordinal()], forgeDirection);
            }
            rh.setTexture(this.getDenseTexture(this.getCableColor()));
            rh.setBounds(3.0f, 3.0f, 3.0f, 13.0f, 13.0f, 13.0f);
            rh.renderBlock(x, y, z, renderer);
        } else {
            ForgeDirection selectedSide = ForgeDirection.UNKNOWN;
            Iterator iterator = this.getConnections().iterator();
            if (iterator.hasNext()) {
                ForgeDirection of2;
                selectedSide = of2 = (ForgeDirection)iterator.next();
            }
            int n = this.getChannelsOnSide()[selectedSide.ordinal()];
            IIcon def = this.getTexture(this.getCableColor());
            OffsetIcon off = new OffsetIcon(def, 0.0f, -12.0f);
            TaughtIcon firstIcon = new TaughtIcon(this.getChannelTex(n, false).getIcon(), -0.2f);
            OffsetIcon firstOffset = new OffsetIcon(firstIcon, 0.0f, -12.0f);
            TaughtIcon secondIcon = new TaughtIcon(this.getChannelTex(n, true).getIcon(), -0.2f);
            OffsetIcon secondOffset = new OffsetIcon(secondIcon, 0.0f, -12.0f);
            switch (selectedSide) {
                case DOWN: 
                case UP: {
                    renderer.func_147782_a(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
                    rh.setTexture(def, def, off, off, off, off);
                    rh.renderBlockCurrentBounds(x, y, z, renderer);
                    renderer.field_147867_u = 0;
                    renderer.field_147865_v = 0;
                    renderer.field_147871_s = 3;
                    renderer.field_147875_q = 3;
                    Tessellator.field_78398_a.func_78380_c(0xF000F0);
                    Tessellator.field_78398_a.func_78378_d(this.getCableColor().blackVariant);
                    rh.setTexture(firstIcon, firstIcon, firstOffset, firstOffset, firstOffset, firstOffset);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    Tessellator.field_78398_a.func_78378_d(this.getCableColor().whiteVariant);
                    rh.setTexture(secondIcon, secondIcon, secondOffset, secondOffset, secondOffset, secondOffset);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    break;
                }
                case EAST: 
                case WEST: {
                    rh.setTexture(off, off, off, off, def, def);
                    renderer.field_147875_q = 2;
                    renderer.field_147873_r = 1;
                    renderer.field_147865_v = 2;
                    renderer.field_147867_u = 1;
                    renderer.field_147871_s = 0;
                    renderer.field_147869_t = 0;
                    AEBaseBlock blk = (AEBaseBlock)rh.getBlock();
                    FlippableIcon ico = blk.getRendererInstance().getTexture(ForgeDirection.EAST);
                    ico.setFlip(false, true);
                    renderer.func_147782_a(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
                    rh.renderBlockCurrentBounds(x, y, z, renderer);
                    Tessellator.field_78398_a.func_78380_c(0xF000F0);
                    FlippableIcon fpA = new FlippableIcon(firstIcon);
                    FlippableIcon fpB = new FlippableIcon(secondIcon);
                    fpA.setFlip(true, false);
                    fpB.setFlip(true, false);
                    Tessellator.field_78398_a.func_78378_d(this.getCableColor().blackVariant);
                    rh.setTexture(firstOffset, firstOffset, firstOffset, firstOffset, firstIcon, fpA);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    Tessellator.field_78398_a.func_78378_d(this.getCableColor().whiteVariant);
                    rh.setTexture(secondOffset, secondOffset, secondOffset, secondOffset, secondIcon, fpB);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    rh.setTexture(off, off, def, def, off, off);
                    renderer.field_147867_u = 3;
                    renderer.field_147865_v = 3;
                    renderer.field_147869_t = 1;
                    renderer.field_147871_s = 2;
                    renderer.field_147873_r = 1;
                    renderer.func_147782_a(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
                    rh.renderBlockCurrentBounds(x, y, z, renderer);
                    Tessellator.field_78398_a.func_78380_c(0xF000F0);
                    Tessellator.field_78398_a.func_78378_d(this.getCableColor().blackVariant);
                    rh.setTexture(firstOffset, firstOffset, firstIcon, firstIcon, firstOffset, firstOffset);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    Tessellator.field_78398_a.func_78378_d(this.getCableColor().whiteVariant);
                    rh.setTexture(secondOffset, secondOffset, secondIcon, secondIcon, secondOffset, secondOffset);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    break;
                }
            }
        }
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        rh.setTexture(null);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderDenseConnection(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer, int channels, ForgeDirection of) {
        TileEntity te = this.getTile().func_145831_w().func_147438_o(x + of.offsetX, y + of.offsetY, z + of.offsetZ);
        IPartHost partHost = te instanceof IPartHost ? (IPartHost)te : null;
        IGridHost ghh = te instanceof IGridHost ? (IGridHost)te : null;
        AEColor myColor = this.getCableColor();
        rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of, of.getOpposite())));
        if (ghh != null && partHost != null && ghh.getCableConnectionType(of) != AECableType.GLASS && partHost.getColor() != AEColor.Transparent && partHost.getPart(of.getOpposite()) == null) {
            myColor = partHost.getColor();
            rh.setTexture(this.getTexture(myColor));
        } else {
            rh.setTexture(this.getTexture(this.getCableColor()));
        }
        switch (of) {
            case DOWN: {
                rh.setBounds(4.0f, 0.0f, 4.0f, 12.0f, 5.0f, 12.0f);
                break;
            }
            case EAST: {
                rh.setBounds(11.0f, 4.0f, 4.0f, 16.0f, 12.0f, 12.0f);
                break;
            }
            case NORTH: {
                rh.setBounds(4.0f, 4.0f, 0.0f, 12.0f, 12.0f, 5.0f);
                break;
            }
            case SOUTH: {
                rh.setBounds(4.0f, 4.0f, 11.0f, 12.0f, 12.0f, 16.0f);
                break;
            }
            case UP: {
                rh.setBounds(4.0f, 11.0f, 4.0f, 12.0f, 16.0f, 12.0f);
                break;
            }
            case WEST: {
                rh.setBounds(0.0f, 4.0f, 4.0f, 5.0f, 12.0f, 12.0f);
                break;
            }
            default: {
                return;
            }
        }
        rh.renderBlock(x, y, z, renderer);
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
        boolean isGlass = false;
        this.setSmartConnectionRotations(of, renderer);
        TaughtIcon firstIcon = new TaughtIcon(this.getChannelTex(channels, false).getIcon(), -0.2f);
        TaughtIcon secondIcon = new TaughtIcon(this.getChannelTex(channels, true).getIcon(), -0.2f);
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        Tessellator.field_78398_a.func_78378_d(myColor.blackVariant);
        rh.setTexture(firstIcon, firstIcon, firstIcon, firstIcon, firstIcon, firstIcon);
        this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
        Tessellator.field_78398_a.func_78378_d(myColor.whiteVariant);
        rh.setTexture(secondIcon, secondIcon, secondIcon, secondIcon, secondIcon, secondIcon);
        this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
    }

    private boolean isSmart(ForgeDirection of) {
        TileEntity te = this.getTile().func_145831_w().func_147438_o(this.getTile().field_145851_c + of.offsetX, this.getTile().field_145848_d + of.offsetY, this.getTile().field_145849_e + of.offsetZ);
        if (te instanceof IGridHost) {
            AECableType t = ((IGridHost)te).getCableConnectionType(of.getOpposite());
            return t == AECableType.SMART;
        }
        return false;
    }

    private IIcon getDenseTexture(AEColor c) {
        switch (c) {
            case Black: {
                return CableBusTextures.MEDense_Black.getIcon();
            }
            case Blue: {
                return CableBusTextures.MEDense_Blue.getIcon();
            }
            case Brown: {
                return CableBusTextures.MEDense_Brown.getIcon();
            }
            case Cyan: {
                return CableBusTextures.MEDense_Cyan.getIcon();
            }
            case Gray: {
                return CableBusTextures.MEDense_Gray.getIcon();
            }
            case Green: {
                return CableBusTextures.MEDense_Green.getIcon();
            }
            case LightBlue: {
                return CableBusTextures.MEDense_LightBlue.getIcon();
            }
            case LightGray: {
                return CableBusTextures.MEDense_LightGrey.getIcon();
            }
            case Lime: {
                return CableBusTextures.MEDense_Lime.getIcon();
            }
            case Magenta: {
                return CableBusTextures.MEDense_Magenta.getIcon();
            }
            case Orange: {
                return CableBusTextures.MEDense_Orange.getIcon();
            }
            case Pink: {
                return CableBusTextures.MEDense_Pink.getIcon();
            }
            case Purple: {
                return CableBusTextures.MEDense_Purple.getIcon();
            }
            case Red: {
                return CableBusTextures.MEDense_Red.getIcon();
            }
            case White: {
                return CableBusTextures.MEDense_White.getIcon();
            }
            case Yellow: {
                return CableBusTextures.MEDense_Yellow.getIcon();
            }
        }
        return this.getItemStack().func_77954_c();
    }

    private boolean isDense(ForgeDirection of) {
        TileEntity te = this.getTile().func_145831_w().func_147438_o(this.getTile().field_145851_c + of.offsetX, this.getTile().field_145848_d + of.offsetY, this.getTile().field_145849_e + of.offsetZ);
        if (te instanceof IGridHost) {
            AECableType t = ((IGridHost)te).getCableConnectionType(of.getOpposite());
            return t == AECableType.DENSE || t == AECableType.DENSE_COVERED;
        }
        return false;
    }

    @MENetworkEventSubscribe
    public void channelUpdated(MENetworkChannelsChanged c) {
        this.getHost().markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }
}

