/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.transformer.annotations.Integration;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nullable;
import li.cil.oc.api.API;
import li.cil.oc.api.Items;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.InterfaceList(value={@Integration.Interface(iface="li.cil.oc.api.network.Environment", iname=IntegrationType.OpenComputers), @Integration.Interface(iface="li.cil.oc.api.network.SidedEnvironment", iname=IntegrationType.OpenComputers)})
public final class PartP2POpenComputers
extends PartP2PTunnel<PartP2POpenComputers>
implements Environment,
SidedEnvironment {
    @Nullable
    private final Node node;

    public PartP2POpenComputers(ItemStack is) {
        super(is);
        if (!IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.OpenComputers)) {
            throw new RuntimeException("OpenComputers is not installed!");
        }
        this.node = API.network != null ? Network.newNode((Environment)this, (Visibility)Visibility.None).create() : null;
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        this.updateConnections();
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        this.updateConnections();
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        this.updateConnections();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Items.get((String)"adapter").block().getBlockTextureFromSide(2);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        if (this.node != null) {
            this.node.remove();
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        this.updateConnections();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (this.node != null) {
            this.node.load(data);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.node != null) {
            this.node.save(data);
        }
    }

    private void updateConnections() {
        if (this.getProxy().isPowered() && this.getProxy().isActive()) {
            Network.joinOrCreateNetwork((TileEntity)this.getTile());
            if (this.isOutput() && this.getInput() != null && this.node != null) {
                Network.joinOrCreateNetwork((TileEntity)((PartP2POpenComputers)this.getInput()).getTile());
                this.node.connect(((PartP2POpenComputers)this.getInput()).node());
            }
        } else if (this.node != null) {
            this.node.remove();
        }
    }

    @Nullable
    public Node node() {
        return this.node;
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }

    @Nullable
    public Node sidedNode(ForgeDirection side) {
        return side == this.getSide() ? this.node : null;
    }

    public boolean canConnect(ForgeDirection side) {
        return side == this.getSide();
    }
}

