/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PartP2PLiquids
extends PartP2PTunnel<PartP2PLiquids>
implements IFluidHandler {
    private static final ThreadLocal<Stack<PartP2PLiquids>> DEPTH = new ThreadLocal();
    private static final FluidTankInfo[] ACTIVE_TANK = new FluidTankInfo[]{new FluidTankInfo(null, 10000)};
    private static final FluidTankInfo[] INACTIVE_TANK = new FluidTankInfo[]{new FluidTankInfo(null, 0)};
    private IFluidHandler cachedTank;
    private int tmpUsed;

    public PartP2PLiquids(ItemStack is) {
        super(is);
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.lapis_block.getBlockTextureFromSide(0);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.cachedTank = null;
    }

    @Override
    public void onNeighborChanged() {
        PartP2PLiquids in;
        this.cachedTank = null;
        if (this.isOutput() && (in = (PartP2PLiquids)this.getInput()) != null) {
            in.onTunnelNetworkChange();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Stack<PartP2PLiquids> stack = this.getDepth();
        for (PartP2PLiquids t : stack) {
            if (t != this) continue;
            return 0;
        }
        stack.push(this);
        List<PartP2PLiquids> list = this.getOutputs(resource.getFluid());
        int requestTotal = 0;
        Iterator<PartP2PLiquids> i = list.iterator();
        while (i.hasNext()) {
            PartP2PLiquids l = i.next();
            IFluidHandler tank = l.getTarget();
            l.tmpUsed = tank != null ? tank.fill(l.getSide().getOpposite(), resource.copy(), false) : 0;
            if (l.tmpUsed <= 0) {
                i.remove();
                continue;
            }
            requestTotal += l.tmpUsed;
        }
        if (requestTotal <= 0) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return 0;
        }
        if (!doFill) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return Math.min(resource.amount, requestTotal);
        }
        int available = resource.amount;
        i = list.iterator();
        int used = 0;
        while (i.hasNext()) {
            IFluidHandler tank;
            PartP2PLiquids l = i.next();
            FluidStack insert = resource.copy();
            insert.amount = (int)Math.ceil((double)insert.amount * ((double)l.tmpUsed / (double)requestTotal));
            if (insert.amount > available) {
                insert.amount = available;
            }
            l.tmpUsed = (tank = l.getTarget()) != null ? tank.fill(l.getSide().getOpposite(), insert, true) : 0;
            available -= l.tmpUsed;
            used += l.tmpUsed;
        }
        if (stack.pop() != this) {
            throw new IllegalStateException("Invalid Recursion detected.");
        }
        return used;
    }

    private Stack<PartP2PLiquids> getDepth() {
        Stack<PartP2PLiquids> s = DEPTH.get();
        if (s == null) {
            s = new Stack();
            DEPTH.set(s);
        }
        return s;
    }

    private List<PartP2PLiquids> getOutputs(Fluid input) {
        LinkedList<PartP2PLiquids> outs = new LinkedList<PartP2PLiquids>();
        try {
            for (PartP2PLiquids l : this.getOutputs()) {
                IFluidHandler handler = l.getTarget();
                if (handler == null || !handler.canFill(l.getSide().getOpposite(), input)) continue;
                outs.add(l);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return outs;
    }

    private IFluidHandler getTarget() {
        if (!this.getProxy().isActive()) {
            return null;
        }
        if (this.cachedTank != null) {
            return this.cachedTank;
        }
        TileEntity te = this.getTile().getWorldObj().getTileEntity(this.getTile().xCoord + this.getSide().offsetX, this.getTile().yCoord + this.getSide().offsetY, this.getTile().zCoord + this.getSide().offsetZ);
        if (te instanceof IFluidHandler) {
            this.cachedTank = (IFluidHandler)te;
            return this.cachedTank;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.isOutput() && from == this.getSide() && !this.getOutputs(fluid).isEmpty();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == this.getSide()) {
            return this.getTank();
        }
        return new FluidTankInfo[0];
    }

    private FluidTankInfo[] getTank() {
        if (this.isOutput()) {
            PartP2PLiquids tun = (PartP2PLiquids)this.getInput();
            if (tun != null) {
                return ACTIVE_TANK;
            }
        } else {
            try {
                if (!this.getOutputs().isEmpty()) {
                    return ACTIVE_TANK;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return INACTIVE_TANK;
    }
}

