/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.quartz;

import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.items.AEBaseItem;
import appeng.items.contents.QuartzKnifeObj;
import appeng.util.Platform;
import com.google.common.base.Optional;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolQuartzCuttingKnife
extends AEBaseItem
implements IGuiItem {
    private final AEFeature type;

    public ToolQuartzCuttingKnife(AEFeature type) {
        super((Optional<String>)Optional.of((Object)type.name()));
        this.type = type;
        this.setFeature(EnumSet.of(type, AEFeature.QuartzKnife));
        this.setMaxDamage(50);
        this.setMaxStackSize(1);
    }

    public boolean onItemUse(ItemStack is, EntityPlayer p, World w, int x, int y, int z, int s, float hitX, float hitY, float hitZ) {
        if (Platform.isServer()) {
            Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_QUARTZ_KNIFE);
        }
        return true;
    }

    public ItemStack onItemRightClick(ItemStack it, World w, EntityPlayer p) {
        if (Platform.isServer()) {
            Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_QUARTZ_KNIFE);
        }
        p.swingItem();
        return it;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack par1ItemStack) {
        return false;
    }

    public boolean getIsRepairable(ItemStack a, ItemStack b) {
        return Platform.canRepair(this.type, a, b);
    }

    public boolean isRepairable() {
        return false;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        itemStack.setItemDamage(itemStack.getItemDamage() + 1);
        return itemStack;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, World world, int x, int y, int z) {
        return new QuartzKnifeObj(is);
    }
}

