/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.core.features.AEFeature;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ToolMemoryCard
extends AEBaseItem
implements IMemoryCard {
    public ToolMemoryCard() {
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.setMaxStackSize(1);
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        lines.add(this.getLocalizedName(this.getSettingsName(stack) + ".name", this.getSettingsName(stack)));
        NBTTagCompound data = this.getData(stack);
        if (data.hasKey("tooltip")) {
            lines.add(StatCollector.translateToLocal((String)this.getLocalizedName(data.getString("tooltip") + ".name", data.getString("tooltip"))));
        }
        if (data.hasKey("freq")) {
            long freq = data.getLong("freq");
            String freqTooltip = String.format("%X", freq).replaceAll("(.{4})", "$0 ").trim();
            String local = ButtonToolTips.P2PFrequency.getLocal();
            lines.add(String.format(local, freqTooltip));
        }
        if (data.hasKey("custom_name")) {
            lines.add(data.getString("custom_name"));
        }
    }

    private String getLocalizedName(String ... name) {
        for (String n3 : name) {
            String l = StatCollector.translateToLocal((String)n3);
            if (l.equals(n3)) continue;
            return l;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String settingsName, NBTTagCompound data) {
        NBTTagCompound c = Platform.openNbtData(is);
        c.setString("Config", settingsName);
        c.setTag("Data", (NBTBase)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        String name = c.getString("Config");
        return name == null || name.isEmpty() ? GuiText.Blank.getUnlocalized() : name;
    }

    @Override
    public NBTTagCompound getData(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        NBTTagCompound o = c.getCompoundTag("Data");
        if (o == null) {
            o = new NBTTagCompound();
        }
        return (NBTTagCompound)o.copy();
    }

    @Override
    public void notifyUser(EntityPlayer player, MemoryCardMessages msg) {
        if (Platform.isClient()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.addChatMessage(PlayerMessages.SettingCleared.get());
                break;
            }
            case INVALID_MACHINE: {
                player.addChatMessage(PlayerMessages.InvalidMachine.get());
                break;
            }
            case SETTINGS_LOADED: {
                player.addChatMessage(PlayerMessages.LoadedSettings.get());
                break;
            }
            case SETTINGS_SAVED: {
                player.addChatMessage(PlayerMessages.SavedSettings.get());
                break;
            }
        }
    }

    public boolean onItemUse(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hx, float hy, float hz) {
        if (player.isSneaking() && !w.isRemote) {
            if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
                return false;
            }
            IMemoryCard mem = (IMemoryCard)is.getItem();
            mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
            is.setTagCompound(null);
            return true;
        }
        return super.onItemUse(is, player, w, x, y, z, side, hx, hy, hz);
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }
}

