/*
 * Decompiled with CFR 0.152.
 */
package appeng.fmp;

import appeng.block.AEBaseItemBlock;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMultiPart;
import appeng.fmp.PartRegistry;
import appeng.integration.modules.helpers.FMPPacketEvent;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class FMPEvent {
    private final ThreadLocal<Object> placing = new ThreadLocal();

    @SubscribeEvent
    public void ServerFMPEvent(FMPPacketEvent event) {
        FMPEvent.place((EntityPlayer)event.getSender(), event.getSender().worldObj);
    }

    private static boolean place(EntityPlayer player, World world) {
        TileMultipart tile;
        MovingObjectPosition hit = RayTracer.reTrace((World)world, (EntityPlayer)player);
        if (hit == null) {
            return false;
        }
        BlockCoord pos = new BlockCoord(hit.blockX, hit.blockY, hit.blockZ).offset(hit.sideHit);
        ItemStack held = player.getHeldItem();
        if (held == null) {
            return false;
        }
        Block blk = null;
        TMultiPart part = null;
        if (held.getItem() instanceof AEBaseItemBlock) {
            AEBaseItemBlock ib = (AEBaseItemBlock)held.getItem();
            blk = Block.getBlockFromItem((Item)ib);
            part = PartRegistry.getPartByBlock(blk, hit.sideHit);
        }
        if (part == null) {
            return false;
        }
        if (world.isRemote && !player.isSneaking()) {
            Vector3 f = new Vector3(hit.hitVec).add((double)(-hit.blockX), (double)(-hit.blockY), (double)(-hit.blockZ));
            Block block = world.getBlock(hit.blockX, hit.blockY, hit.blockZ);
            if (block != null && !FMPEvent.ignoreActivate(block) && block.onBlockActivated(world, hit.blockX, hit.blockY, hit.blockZ, player, hit.sideHit, (float)f.x, (float)f.y, (float)f.z)) {
                player.swingItem();
                PacketCustom.sendToServer((Packet)new C08PacketPlayerBlockPlacement(hit.blockX, hit.blockY, hit.blockZ, hit.sideHit, player.inventory.getCurrentItem(), (float)f.x, (float)f.y, (float)f.z));
                return true;
            }
        }
        if ((tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos)) == null || !tile.canAddPart(part)) {
            return false;
        }
        if (!world.isRemote) {
            TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
            world.playSoundEffect((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, blk.stepSound.func_150496_b(), (blk.stepSound.getVolume() + 1.0f) / 2.0f, blk.stepSound.getPitch() * 0.8f);
            if (!player.capabilities.isCreativeMode) {
                --held.stackSize;
                if (held.stackSize == 0) {
                    player.inventory.mainInventory[player.inventory.currentItem] = null;
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held));
                }
            }
        } else {
            player.swingItem();
            NetworkHandler.instance.sendToServer(new PacketMultiPart());
        }
        return true;
    }

    private static boolean ignoreActivate(Block block) {
        return block instanceof BlockFence;
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.worldObj.isRemote) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            if (FMPEvent.place(event.entityPlayer, event.entityPlayer.worldObj)) {
                event.setCanceled(true);
            }
            this.placing.set(null);
        }
    }
}

