/*
 * Decompiled with CFR 0.152.
 */
package appeng.fmp;

import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.BusRenderer;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.fmp.PartRegistry;
import appeng.helpers.AEMultiTile;
import appeng.parts.BusCollisionHelper;
import appeng.parts.CableBusContainer;
import appeng.parts.PartPlacement;
import appeng.tile.networking.TileCableBus;
import appeng.util.Platform;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IMaskedRedstonePart;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.scalatraits.TIInventoryTile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class CableBusPart
extends JCuboidPart
implements JNormalOcclusion,
IMaskedRedstonePart,
AEMultiTile {
    private static final ThreadLocal<Boolean> DISABLE_FACADE_OCCLUSION = new ThreadLocal();
    private static final double SHORTER = 0.375;
    private static final double LONGER = 0.625;
    private static final double MIN_DIRECTION = 0.0;
    private static final double MAX_DIRECTION = 1.0;
    private static final Cuboid6[] SIDE_TESTS = new Cuboid6[]{new Cuboid6(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new Cuboid6(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), new Cuboid6(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), new Cuboid6(0.375, 0.375, 0.625, 0.625, 0.625, 1.0), new Cuboid6(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), new Cuboid6(0.625, 0.375, 0.375, 1.0, 0.625, 0.625)};
    private static final int CONNECTION_MASK = 16;
    private CableBusContainer cb = new CableBusContainer(this);
    private boolean canUpdate = false;

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor colour, EntityPlayer who) {
        return this.getCableBus().recolourBlock(side, colour, who);
    }

    public Cuboid6 getBounds() {
        AxisAlignedBB b = null;
        for (AxisAlignedBB bx : this.getCableBus().getSelectedBoundingBoxesFromPool(false, true, null, true)) {
            if (b == null) {
                b = bx;
                continue;
            }
            double minX = Math.min(b.minX, bx.minX);
            double minY = Math.min(b.minY, bx.minY);
            double minZ = Math.min(b.minZ, bx.minZ);
            double maxX = Math.max(b.maxX, bx.maxX);
            double maxY = Math.max(b.maxY, bx.maxY);
            double maxZ = Math.max(b.maxZ, bx.maxZ);
            b.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }
        if (b == null) {
            return new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return new Cuboid6(b.minX, b.minY, b.minZ, b.maxX, b.maxY, b.maxZ);
    }

    public String getType() {
        return PartRegistry.CableBusPart.getName();
    }

    public int getLightValue() {
        return this.getCableBus().getLightValue();
    }

    public void onWorldJoin() {
        this.canUpdate = true;
        this.getCableBus().updateConnections();
        this.getCableBus().addToWorld();
    }

    public boolean occlusionTest(TMultiPart part) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)part);
    }

    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass == 0 || pass == 1 && AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass)) {
            BusRenderHelper.INSTANCE.setPass(pass);
            BusRenderer.INSTANCE.getRenderer().renderAllFaces = true;
            BusRenderer.INSTANCE.getRenderer().blockAccess = this.world();
            BusRenderer.INSTANCE.getRenderer().overrideBlockTexture = null;
            this.getCableBus().renderStatic(pos.x, pos.y, pos.z);
            return BusRenderHelper.INSTANCE.getItemsRendered() > 0;
        }
        return false;
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0 || pass == 1 && AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass)) {
            BusRenderHelper.INSTANCE.setPass(pass);
            this.getCableBus().renderDynamic(pos.x, pos.y, pos.z);
        }
    }

    public void onPartChanged(TMultiPart part) {
        this.getCableBus().updateConnections();
    }

    public void onEntityCollision(Entity entity) {
        this.getCableBus().onEntityCollision(entity);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        return this.getCableBus().activate(player, hit.hitVec.addVector((double)(-hit.blockX), (double)(-hit.blockY), (double)(-hit.blockZ)));
    }

    public void load(NBTTagCompound tag) {
        this.getCableBus().readFromNBT(tag);
    }

    public void onWorldSeparate() {
        this.canUpdate = false;
        this.getCableBus().removeFromWorld();
    }

    public void save(NBTTagCompound tag) {
        this.getCableBus().writeToNBT(tag);
    }

    public void writeDesc(MCDataOutput packet) {
        ByteBuf stream = Unpooled.buffer();
        try {
            this.getCableBus().writeToStream(stream);
            packet.writeInt(stream.readableBytes());
            stream.capacity(stream.readableBytes());
            packet.writeByteArray(stream.array());
        }
        catch (IOException e) {
            AELog.debug(e);
        }
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        Vec3 v3 = hit.hitVec.addVector((double)(-hit.blockX), (double)(-hit.blockY), (double)(-hit.blockZ));
        SelectedPart sp = this.getCableBus().selectPart(v3);
        if (sp != null) {
            if (sp.part != null) {
                return sp.part.getItemStack(PartItemStack.Break);
            }
            if (sp.facade != null) {
                return sp.facade.getItemStack();
            }
        }
        return null;
    }

    public Iterable<ItemStack> getDrops() {
        return this.getCableBus().getDrops(new ArrayList());
    }

    public void onNeighborChanged() {
        this.getCableBus().onNeighborChanged();
    }

    public boolean doesTick() {
        return false;
    }

    public void invalidateConvertedTile() {
        this.getCableBus().setHost(this);
    }

    public void readDesc(MCDataInput packet) {
        int len = packet.readInt();
        byte[] data = packet.readByteArray(len);
        try {
            if (len > 0) {
                ByteBuf byteBuffer = Unpooled.wrappedBuffer((byte[])data);
                this.getCableBus().readFromStream(byteBuffer);
            }
        }
        catch (IOException e) {
            AELog.debug(e);
        }
    }

    public boolean canConnectRedstone(int side) {
        return this.getCableBus().canConnectRedstone(EnumSet.of(ForgeDirection.getOrientation((int)side)));
    }

    public int weakPowerLevel(int side) {
        return this.getCableBus().isProvidingWeakPower(ForgeDirection.getOrientation((int)side));
    }

    public int strongPowerLevel(int side) {
        return this.getCableBus().isProvidingStrongPower(ForgeDirection.getOrientation((int)side));
    }

    public void convertFromTile(TileEntity blockTileEntity) {
        TileCableBus tcb = (TileCableBus)blockTileEntity;
        this.setCableBus(tcb.getCableBus());
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        LinkedList<Cuboid6> l = new LinkedList<Cuboid6>();
        for (AxisAlignedBB b : this.getCableBus().getSelectedBoundingBoxesFromPool(true, DISABLE_FACADE_OCCLUSION.get() == null, null, true)) {
            l.add(new Cuboid6(b.minX, b.minY, b.minZ, b.maxX, b.maxY, b.maxZ));
        }
        return l;
    }

    @Override
    public IGridNode getGridNode(ForgeDirection dir) {
        return this.getCableBus().getGridNode(dir);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return this.getCableBus().getCableConnectionType(dir);
    }

    @Override
    public void securityBreak() {
        this.getCableBus().securityBreak();
    }

    public int getHollowSize(int side) {
        IPartCable cable = (IPartCable)this.getPart(ForgeDirection.UNKNOWN);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (cable != null && cable.isConnected(dir)) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            BusCollisionHelper bch = new BusCollisionHelper(boxes, ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.SOUTH, null, true);
            for (ForgeDirection whichSide : ForgeDirection.values()) {
                IPart fPart = this.getPart(whichSide);
                if (fPart == null) continue;
                fPart.getBoxes(bch);
            }
            AxisAlignedBB b = null;
            AxisAlignedBB pb = Platform.getPrimaryBox(dir, 2);
            for (AxisAlignedBB bb : boxes) {
                if (!bb.intersectsWith(pb)) continue;
                if (b == null) {
                    b = bb;
                    continue;
                }
                b.maxX = Math.max(b.maxX, bb.maxX);
                b.maxY = Math.max(b.maxY, bb.maxY);
                b.maxZ = Math.max(b.maxZ, bb.maxZ);
                b.minX = Math.min(b.minX, bb.minX);
                b.minY = Math.min(b.minY, bb.minY);
                b.minZ = Math.min(b.minZ, bb.minZ);
            }
            if (b == null) {
                return 0;
            }
            switch (dir) {
                case WEST: 
                case EAST: {
                    return this.getSize(b.minZ, b.maxZ, b.minY, b.maxY);
                }
                case DOWN: 
                case NORTH: {
                    return this.getSize(b.minX, b.maxX, b.minZ, b.maxZ);
                }
                case SOUTH: 
                case UP: {
                    return this.getSize(b.minX, b.maxX, b.minY, b.maxY);
                }
            }
        }
        return 12;
    }

    private int getSize(double a, double b, double c, double d) {
        double r = Math.abs(a - 0.5);
        r = Math.max(Math.abs(b - 0.5), r);
        r = Math.max(Math.abs(c - 0.5), r);
        return 8 * (int)Math.max(Math.abs(d - 0.5), r);
    }

    public int getSlotMask() {
        int mask = 0;
        for (ForgeDirection side : ForgeDirection.values()) {
            if (this.getPart(side) != null) {
                mask |= 1 << side.ordinal();
                continue;
            }
            if (side == ForgeDirection.UNKNOWN || this.getFacadeContainer().getFacade(side) == null) continue;
            mask |= 1 << side.ordinal();
        }
        return mask;
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return this.getCableBus().getFacadeContainer();
    }

    @Override
    public boolean canAddPart(ItemStack is, ForgeDirection side) {
        IFacadePart fp = PartPlacement.isFacade(is, side);
        if (fp != null) {
            if (side != null && side != ForgeDirection.UNKNOWN && this.tile() != null) {
                ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
                BusCollisionHelper bch = new BusCollisionHelper(boxes, side, null, true);
                fp.getBoxes(bch, null);
                for (AxisAlignedBB bb : boxes) {
                    DISABLE_FACADE_OCCLUSION.set(true);
                    boolean canAdd = this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(new Cuboid6(bb)));
                    DISABLE_FACADE_OCCLUSION.remove();
                    if (canAdd) continue;
                    return false;
                }
            }
            return true;
        }
        if (is.getItem() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.getItem();
            is = is.copy();
            is.stackSize = 1;
            IPart bp = bi.createPartFromItemStack(is);
            if (side != null && side != ForgeDirection.UNKNOWN && this.tile() != null) {
                ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
                BusCollisionHelper bch = new BusCollisionHelper(boxes, side, null, true);
                if (bp != null) {
                    bp.getBoxes(bch);
                }
                for (AxisAlignedBB bb : boxes) {
                    if (this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(new Cuboid6(bb)))) continue;
                    return false;
                }
            }
        }
        return this.getCableBus().canAddPart(is, side);
    }

    @Override
    public ForgeDirection addPart(ItemStack is, ForgeDirection side, EntityPlayer owner) {
        return this.getCableBus().addPart(is, side, owner);
    }

    @Override
    public IPart getPart(ForgeDirection side) {
        return this.getCableBus().getPart(side);
    }

    @Override
    public void removePart(ForgeDirection side, boolean suppressUpdate) {
        this.getCableBus().removePart(side, suppressUpdate);
    }

    @Override
    public void markForUpdate() {
        if (Platform.isServer() && this.canUpdate) {
            this.sendDescUpdate();
        }
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this.tile());
    }

    @Override
    public AEColor getColor() {
        return this.getCableBus().getColor();
    }

    @Override
    public void clearContainer() {
        this.setCableBus(new CableBusContainer(this));
    }

    @Override
    public boolean isBlocked(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN || this.tile() == null) {
            return false;
        }
        DISABLE_FACADE_OCCLUSION.set(true);
        int ordinal = side.ordinal();
        Cuboid6 sideTest = SIDE_TESTS[ordinal];
        NormallyOccludedPart occludedPart = new NormallyOccludedPart(sideTest);
        boolean blocked = !this.tile().canAddPart((TMultiPart)occludedPart);
        DISABLE_FACADE_OCCLUSION.remove();
        return blocked;
    }

    @Override
    public SelectedPart selectPart(Vec3 pos) {
        return this.getCableBus().selectPart(pos);
    }

    @Override
    public void markForSave() {
        TileMultipart te = this.tile();
        if (te != null && te.getWorldObj() != null) {
            te.getWorldObj().getChunkFromBlockCoords((int)this.x(), (int)this.z()).isModified = true;
        }
    }

    @Override
    public void partChanged() {
        if (this.isInWorld()) {
            this.notifyNeighbors();
        }
    }

    @Override
    public boolean hasRedstone(ForgeDirection side) {
        return this.getCableBus().hasRedstone(side);
    }

    @Override
    public boolean isEmpty() {
        return this.getCableBus().isEmpty();
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.getCableBus().getLayerFlags();
    }

    @Override
    public void cleanup() {
        this.tile().remPart((TMultiPart)this);
    }

    @Override
    public void notifyNeighbors() {
        if (this.tile() instanceof TIInventoryTile) {
            ((TIInventoryTile)this.tile()).rebuildSlotMap();
        }
        if (this.world() != null && this.world().blockExists(this.x(), this.y(), this.z()) && !CableBusContainer.isLoading()) {
            Platform.notifyBlocksOfNeighbors(this.world(), this.x(), this.y(), this.z());
        }
    }

    @Override
    public boolean isInWorld() {
        return this.getCableBus().isInWorld();
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        LinkedList<Cuboid6> l = new LinkedList<Cuboid6>();
        for (AxisAlignedBB b : this.getCableBus().getSelectedBoundingBoxesFromPool(false, true, null, true)) {
            l.add(new Cuboid6(b.minX, b.minY, b.minZ, b.maxX, b.maxY, b.maxZ));
        }
        return l;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        LinkedList<IndexedCuboid6> l = new LinkedList<IndexedCuboid6>();
        for (Cuboid6 c : this.getCollisionBoxes()) {
            l.add(new IndexedCuboid6((Object)0, c));
        }
        return l;
    }

    public int getConnectionMask(int side) {
        return 16;
    }

    public CableBusContainer getCableBus() {
        return this.cb;
    }

    private void setCableBus(CableBusContainer cb) {
        this.cb = cb;
    }
}

