/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.items.misc.ItemEncodedPattern;
import appeng.parts.misc.PartInterface;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.TileInterface;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.inv.WrapperInvSlot;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class ContainerInterfaceTerminal
extends AEBaseContainer {
    private static long autoBase = Long.MIN_VALUE;
    private final Multimap<IInterfaceHost, InvTracker> diList = HashMultimap.create();
    private final Map<Long, InvTracker> byId = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();

    public ContainerInterfaceTerminal(InventoryPlayer ip, PartInterfaceTerminal anchor) {
        super(ip, anchor);
        if (Platform.isServer()) {
            this.grid = anchor.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 0, 140);
    }

    @Override
    public void detectAndSendChanges() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.detectAndSendChanges();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            InterfaceCheck interfaceCheck;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                interfaceCheck = new InterfaceCheck().invoke(gn);
                total += interfaceCheck.getTotal();
                missing |= interfaceCheck.isMissing();
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                interfaceCheck = new InterfaceCheck().invoke(gn);
                total += interfaceCheck.getTotal();
                missing |= interfaceCheck.isMissing();
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (InvTracker inv : this.diList.values()) {
                for (int x = 0; x < inv.client.getSizeInventory(); ++x) {
                    if (!this.isDifferent(inv.server.getStackInSlot(inv.offset + x), inv.client.getStackInSlot(x))) continue;
                    this.addItems(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.hasNoTags()) {
            try {
                NetworkHandler.instance.sendTo(new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().player);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new NBTTagCompound();
        }
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        InvTracker inv = this.byId.get(id);
        if (inv != null) {
            ItemStack is = inv.server.getStackInSlot(slot + inv.offset);
            boolean hasItemInHand = player.inventory.getItemStack() != null;
            AdaptorPlayerHand playerHand = new AdaptorPlayerHand((EntityPlayer)player);
            PatternInvSlot slotInv = new PatternInvSlot(inv.server);
            IInventory theSlot = slotInv.getWrapper(slot + inv.offset);
            AdaptorIInventory interfaceSlot = new AdaptorIInventory(theSlot);
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        ItemStack inSlot = theSlot.getStackInSlot(0);
                        if (inSlot == null) {
                            player.inventory.setItemStack(((InventoryAdaptor)interfaceSlot).addItems(player.inventory.getItemStack()));
                            break;
                        }
                        inSlot = inSlot.copy();
                        ItemStack inHand = player.inventory.getItemStack().copy();
                        theSlot.setInventorySlotContents(0, null);
                        player.inventory.setItemStack(null);
                        player.inventory.setItemStack(((InventoryAdaptor)interfaceSlot).addItems(inHand.copy()));
                        if (player.inventory.getItemStack() == null) {
                            player.inventory.setItemStack(inSlot);
                            break;
                        }
                        player.inventory.setItemStack(inHand);
                        theSlot.setInventorySlotContents(0, inSlot);
                        break;
                    }
                    IInventory mySlot = slotInv.getWrapper(slot + inv.offset);
                    mySlot.setInventorySlotContents(0, ((InventoryAdaptor)playerHand).addItems(mySlot.getStackInSlot(0)));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        ItemStack extra = ((InventoryAdaptor)playerHand).removeItems(1, null, null);
                        if (extra != null) {
                            extra = ((InventoryAdaptor)interfaceSlot).addItems(extra);
                        }
                        if (extra == null) break;
                        ((InventoryAdaptor)playerHand).addItems(extra);
                        break;
                    }
                    if (is == null) break;
                    ItemStack extra = ((InventoryAdaptor)interfaceSlot).removeItems((is.stackSize + 1) / 2, null, null);
                    if (extra != null) {
                        extra = ((InventoryAdaptor)playerHand).addItems(extra);
                    }
                    if (extra == null) break;
                    ((InventoryAdaptor)interfaceSlot).addItems(extra);
                    break;
                }
                case SHIFT_CLICK: {
                    IInventory mySlot = slotInv.getWrapper(slot + inv.offset);
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(player, ForgeDirection.UNKNOWN);
                    mySlot.setInventorySlotContents(0, playerInv.addItems(mySlot.getStackInSlot(0)));
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor(player, ForgeDirection.UNKNOWN);
                    for (int x = 0; x < inv.client.getSizeInventory(); ++x) {
                        inv.server.setInventorySlotContents(x + inv.offset, playerInvAd.addItems(inv.server.getStackInSlot(x + inv.offset)));
                    }
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.capabilities.isCreativeMode || hasItemInHand) break;
                    player.inventory.setItemStack(is == null ? null : is.copy());
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            int i;
            DualityInterface dual;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                for (i = 0; i <= dual.getInstalledUpgrades(Upgrades.PATTERN_CAPACITY); ++i) {
                    this.diList.put((Object)ih, (Object)new InvTracker(dual, dual.getPatterns(), dual.getTermName(), i * 9, 9));
                }
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                for (i = 0; i <= dual.getInstalledUpgrades(Upgrades.PATTERN_CAPACITY); ++i) {
                    this.diList.put((Object)ih, (Object)new InvTracker(dual, dual.getPatterns(), dual.getTermName(), i * 9, 9));
                }
            }
        }
        data.setBoolean("clear", true);
        for (InvTracker inv : this.diList.values()) {
            this.byId.put(inv.which, inv);
            this.addItems(data, inv, 0, inv.client.getSizeInventory());
        }
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        return !ItemStack.areItemStacksEqual((ItemStack)a, (ItemStack)b);
    }

    private void addItems(NBTTagCompound data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.getCompoundTag(name);
        if (tag.hasNoTags()) {
            tag.setLong("sortBy", inv.sortBy);
            tag.setString("un", inv.unlocalizedName);
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = inv.server.getStackInSlot(x + offset + inv.offset);
            inv.client.setInventorySlotContents(offset + x, is == null ? null : is.copy());
            if (is != null) {
                is.writeToNBT(itemNBT);
            }
            tag.setTag(Integer.toString(x + offset), (NBTBase)itemNBT);
        }
        data.setTag(name, (NBTBase)tag);
    }

    static /* synthetic */ long access$608() {
        return autoBase++;
    }

    private class InterfaceCheck {
        int total = 0;
        boolean missing = false;

        public int getTotal() {
            return this.total;
        }

        public boolean isMissing() {
            return this.missing;
        }

        public InterfaceCheck invoke(IGridNode gn) {
            if (gn.isActive()) {
                IInterfaceHost ih = (IInterfaceHost)gn.getMachine();
                if (ih.getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) {
                    return this;
                }
                Collection t = ContainerInterfaceTerminal.this.diList.get((Object)ih);
                if (t.isEmpty()) {
                    this.missing = true;
                } else {
                    DualityInterface dual = ih.getInterfaceDuality();
                    for (InvTracker it : t) {
                        if (it.unlocalizedName.equals(dual.getTermName())) continue;
                        this.missing = true;
                    }
                }
                this.total += ih.getInterfaceDuality().getInstalledUpgrades(Upgrades.PATTERN_CAPACITY) + 1;
            }
            return this;
        }
    }

    private static class PatternInvSlot
    extends WrapperInvSlot {
        public PatternInvSlot(IInventory inv) {
            super(inv);
        }

        @Override
        public boolean isItemValid(ItemStack itemstack) {
            return itemstack != null && itemstack.getItem() instanceof ItemEncodedPattern;
        }
    }

    private static class InvTracker {
        private final long sortBy;
        private final long which = ContainerInterfaceTerminal.access$608();
        private final String unlocalizedName;
        private final IInventory client;
        private final IInventory server;
        private final int offset;

        public InvTracker(DualityInterface dual, IInventory patterns, String unlocalizedName, int offset, int size) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(null, size);
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue() + (long)offset << 16;
            this.offset = offset;
        }
    }
}

