/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IMaterials;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.worlddata.WorldData;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.worldgen.meteorite.Fallout;
import appeng.worldgen.meteorite.FalloutCopy;
import appeng.worldgen.meteorite.FalloutSand;
import appeng.worldgen.meteorite.FalloutSnow;
import appeng.worldgen.meteorite.IMeteoriteWorld;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public final class MeteoritePlacer {
    private static final double PRESSES_SPAWN_CHANCE = 0.7;
    private static final int SKYSTONE_SPAWN_LIMIT = 12;
    private final Collection<Block> validSpawn = new HashSet<Block>();
    private final Collection<Block> invalidSpawn = new HashSet<Block>();
    private final IBlockDefinition skyChestDefinition;
    private final IBlockDefinition skyStoneDefinition;
    private final MeteoriteBlockPutter putter = new MeteoriteBlockPutter();
    private double meteoriteSize = Math.random() * 6.0 + 2.0;
    private double realCrater = this.meteoriteSize * 2.0 + 5.0;
    private double squaredMeteoriteSize = this.meteoriteSize * this.meteoriteSize;
    private double crater = this.realCrater * this.realCrater;
    private NBTTagCompound settings;
    private Fallout type;

    public MeteoritePlacer() {
        IBlocks blocks = AEApi.instance().definitions().blocks();
        this.skyChestDefinition = blocks.skyChest();
        this.skyStoneDefinition = blocks.skyStone();
        this.validSpawn.add(Blocks.stone);
        this.validSpawn.add(Blocks.cobblestone);
        this.validSpawn.add((Block)Blocks.grass);
        this.validSpawn.add((Block)Blocks.sand);
        this.validSpawn.add(Blocks.dirt);
        this.validSpawn.add(Blocks.gravel);
        this.validSpawn.add(Blocks.netherrack);
        this.validSpawn.add(Blocks.iron_ore);
        this.validSpawn.add(Blocks.gold_ore);
        this.validSpawn.add(Blocks.diamond_ore);
        this.validSpawn.add(Blocks.redstone_ore);
        this.validSpawn.add(Blocks.hardened_clay);
        this.validSpawn.add(Blocks.ice);
        this.validSpawn.add(Blocks.snow);
        this.validSpawn.add(Blocks.stained_hardened_clay);
        for (Block skyStoneBlock : this.skyStoneDefinition.maybeBlock().asSet()) {
            this.invalidSpawn.add(skyStoneBlock);
        }
        this.invalidSpawn.add(Blocks.planks);
        this.invalidSpawn.add(Blocks.iron_door);
        this.invalidSpawn.add(Blocks.iron_bars);
        this.invalidSpawn.add(Blocks.wooden_door);
        this.invalidSpawn.add(Blocks.brick_block);
        this.invalidSpawn.add(Blocks.clay);
        this.invalidSpawn.add(Blocks.water);
        this.invalidSpawn.add(Blocks.log);
        this.invalidSpawn.add(Blocks.log2);
        this.type = new Fallout(this.putter, this.skyStoneDefinition);
    }

    boolean spawnMeteorite(IMeteoriteWorld w, NBTTagCompound meteoriteBlob) {
        this.settings = meteoriteBlob;
        int x = this.settings.getInteger("x");
        int y = this.settings.getInteger("y");
        int z = this.settings.getInteger("z");
        this.meteoriteSize = this.settings.getDouble("real_sizeOfMeteorite");
        this.realCrater = this.settings.getDouble("realCrater");
        this.squaredMeteoriteSize = this.settings.getDouble("sizeOfMeteorite");
        this.crater = this.settings.getDouble("crater");
        Block blk = Block.getBlockById((int)this.settings.getInteger("blk"));
        if (blk == Blocks.sand) {
            this.type = new FalloutSand(w, x, y, z, this.putter, this.skyStoneDefinition);
        } else if (blk == Blocks.hardened_clay) {
            this.type = new FalloutCopy(w, x, y, z, this.putter, this.skyStoneDefinition);
        } else if (blk == Blocks.ice || blk == Blocks.snow) {
            this.type = new FalloutSnow(w, x, y, z, this.putter, this.skyStoneDefinition);
        }
        int skyMode = this.settings.getInteger("skyMode");
        if (skyMode > 10) {
            this.placeCrater(w, x, y, z);
        }
        this.placeMeteorite(w, x, y, z);
        if (skyMode > 3) {
            this.decay(w, x, y, z);
        }
        w.done();
        return true;
    }

    private void placeCrater(IMeteoriteWorld w, int x, int y, int z) {
        boolean lava = this.settings.getBoolean("lava");
        int maxY = 255;
        int minX = w.minX(x - 200);
        int maxX = w.maxX(x + 200);
        int minZ = w.minZ(z - 200);
        int maxZ = w.maxZ(z + 200);
        for (int j = y - 5; j < 255; ++j) {
            boolean changed = false;
            for (int i = minX; i < maxX; ++i) {
                for (int k = minZ; k < maxZ; ++k) {
                    double distanceFrom;
                    double dx = i - x;
                    double dz = k - z;
                    double h = (double)y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    if (!((double)j > h + (distanceFrom = dx * dx + dz * dz) * 0.02)) continue;
                    if (lava && j < y && w.getBlock(x, y - 1, z).isBlockSolid((IBlockAccess)w.getWorld(), i, j, k, 0)) {
                        if (!((double)j > h + distanceFrom * 0.02)) continue;
                        this.putter.put(w, i, j, k, Blocks.lava);
                        continue;
                    }
                    changed = this.putter.put(w, i, j, k, Platform.AIR_BLOCK) || changed;
                }
            }
        }
        for (Object o : w.getWorld().getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)w.minX(x - 30), (double)(y - 5), (double)w.minZ(z - 30), (double)w.maxX(x + 30), (double)(y + 30), (double)w.maxZ(z + 30)))) {
            Entity e = (Entity)o;
            e.setDead();
        }
    }

    private void placeMeteorite(IMeteoriteWorld w, int x, int y, int z) {
        int meteorXLength = w.minX(x - 8);
        int meteorXHeight = w.maxX(x + 8);
        int meteorZLength = w.minZ(z - 8);
        int meteorZHeight = w.maxZ(z + 8);
        for (int i = meteorXLength; i < meteorXHeight; ++i) {
            for (int j = y - 8; j < y + 8; ++j) {
                for (int k = meteorZLength; k < meteorZHeight; ++k) {
                    double dx = i - x;
                    double dy = j - y;
                    double dz = k - z;
                    double d = j > y ? 1.4 : 0.8;
                    if (!(dx * dx * 0.7 + dy * dy * d + dz * dz * 0.7 < this.squaredMeteoriteSize)) continue;
                    for (Block skyStoneBlock : this.skyStoneDefinition.maybeBlock().asSet()) {
                        this.putter.put(w, i, j, k, skyStoneBlock);
                    }
                }
            }
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.SpawnPressesInMeteorites)) {
            for (Block skyChestBlock : this.skyChestDefinition.maybeBlock().asSet()) {
                this.putter.put(w, x, y, z, skyChestBlock);
            }
            TileEntity te = w.getTileEntity(x, y, z);
            if (te instanceof IInventory) {
                InventoryAdaptor ap = InventoryAdaptor.getAdaptor(te, ForgeDirection.UP);
                int primary = Math.max(1, (int)(Math.random() * 4.0));
                if (primary > 3) {
                    primary = 3;
                }
                for (int zz = 0; zz < primary; ++zz) {
                    int r = 0;
                    boolean duplicate = false;
                    do {
                        duplicate = false;
                        r = Math.random() > 0.7 ? WorldData.instance().storageData().getNextOrderedValue("presses") : (int)(Math.random() * 1000.0);
                        ItemStack toAdd = null;
                        IMaterials materials = AEApi.instance().definitions().materials();
                        switch (r % 4) {
                            case 0: {
                                ItemStack calc;
                                Iterator iterator = materials.calcProcessorPress().maybeStack(1).asSet().iterator();
                                while (iterator.hasNext()) {
                                    toAdd = calc = (ItemStack)iterator.next();
                                }
                                break;
                            }
                            case 1: {
                                ItemStack calc;
                                Iterator iterator = materials.engProcessorPress().maybeStack(1).asSet().iterator();
                                while (iterator.hasNext()) {
                                    toAdd = calc = (ItemStack)iterator.next();
                                }
                                break;
                            }
                            case 2: {
                                ItemStack calc;
                                Iterator iterator = materials.logicProcessorPress().maybeStack(1).asSet().iterator();
                                while (iterator.hasNext()) {
                                    toAdd = calc = (ItemStack)iterator.next();
                                }
                                break;
                            }
                            case 3: {
                                ItemStack calc;
                                Iterator iterator = materials.siliconPress().maybeStack(1).asSet().iterator();
                                while (iterator.hasNext()) {
                                    toAdd = calc = (ItemStack)iterator.next();
                                }
                                break;
                            }
                        }
                        if (toAdd == null) continue;
                        if (ap.simulateRemove(1, toAdd, null) == null) {
                            ap.addItems(toAdd);
                            continue;
                        }
                        duplicate = true;
                    } while (duplicate);
                }
                int secondary = Math.max(1, (int)(Math.random() * 3.0));
                block21: for (int zz = 0; zz < secondary; ++zz) {
                    switch ((int)(Math.random() * 1000.0) % 3) {
                        case 0: {
                            int amount = (int)(Math.random() * 12.0 + 1.0);
                            for (ItemStack skyStoneStack : this.skyStoneDefinition.maybeStack(amount).asSet()) {
                                ap.addItems(skyStoneStack);
                            }
                            continue block21;
                        }
                        case 1: {
                            LinkedList<ItemStack> possibles = new LinkedList<ItemStack>();
                            possibles.addAll(OreDictionary.getOres((String)"nuggetIron"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetCopper"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetTin"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetSilver"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetLead"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetPlatinum"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetNickel"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetAluminium"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetElectrum"));
                            possibles.add(new ItemStack(Items.gold_nugget));
                            ItemStack nugget = (ItemStack)Platform.pickRandom(possibles);
                            if (nugget == null) continue block21;
                            nugget = nugget.copy();
                            nugget.stackSize = (int)(Math.random() * 12.0) + 1;
                            ap.addItems(nugget);
                        }
                    }
                }
            }
        }
    }

    private void decay(IMeteoriteWorld w, int x, int y, int z) {
        double randomShit = 0.0;
        int meteorXLength = w.minX(x - 30);
        int meteorXHeight = w.maxX(x + 30);
        int meteorZLength = w.minZ(z - 30);
        int meteorZHeight = w.maxZ(z + 30);
        for (int i = meteorXLength; i < meteorXHeight; ++i) {
            for (int k = meteorZLength; k < meteorZHeight; ++k) {
                for (int j = y - 9; j < y + 30; ++j) {
                    double dx;
                    double dz;
                    double dy;
                    Block blk_b;
                    Block blk = w.getBlock(i, j, k);
                    if (blk == Blocks.lava) continue;
                    if (blk.isReplaceable((IBlockAccess)w.getWorld(), i, j, k)) {
                        blk = Platform.AIR_BLOCK;
                        blk_b = w.getBlock(i, j + 1, k);
                        if (blk_b != blk) {
                            int meta_b = w.getBlockMetadata(i, j + 1, k);
                            w.setBlock(i, j, k, blk_b, meta_b, 3);
                            w.setBlock(i, j + 1, k, blk);
                            continue;
                        }
                        if (!(randomShit < 100.0 * this.crater)) continue;
                        double dx2 = i - x;
                        dy = j - y;
                        dz = k - z;
                        double dist = dx2 * dx2 + dy * dy + dz * dz;
                        Block xf = w.getBlock(i, j - 1, k);
                        if (xf.isReplaceable((IBlockAccess)w.getWorld(), i, j - 1, k)) continue;
                        double extraRange = Math.random() * 0.6;
                        double height = this.crater * (extraRange + 0.2) - Math.abs(dist - this.crater * 1.7);
                        if (xf == blk || !(height > 0.0) || !(Math.random() > 0.6)) continue;
                        randomShit += 1.0;
                        this.type.getRandomFall(w, i, j, k);
                        continue;
                    }
                    blk_b = w.getBlock(i, j + 1, k);
                    if (blk_b != Platform.AIR_BLOCK || !(Math.random() > 0.4) || !((dx = (double)(i - x)) * dx + (dy = (double)(j - y)) * dy + (dz = (double)(k - z)) * dz < this.crater * 1.6)) continue;
                    this.type.getRandomInset(w, i, j, k);
                }
            }
        }
    }

    double getSqDistance(int x, int z) {
        int chunkX = this.settings.getInteger("x") - x;
        int chunkZ = this.settings.getInteger("z") - z;
        return chunkX * chunkX + chunkZ * chunkZ;
    }

    public boolean spawnMeteorite(IMeteoriteWorld w, int x, int y, int z) {
        if (!w.hasNoSky()) {
            return false;
        }
        Block blk = w.getBlock(x, y, z);
        if (!this.validSpawn.contains(blk)) {
            return false;
        }
        this.settings = new NBTTagCompound();
        this.settings.setInteger("x", x);
        this.settings.setInteger("y", y);
        this.settings.setInteger("z", z);
        this.settings.setInteger("blk", Block.getIdFromBlock((Block)blk));
        this.settings.setDouble("real_sizeOfMeteorite", this.meteoriteSize);
        this.settings.setDouble("realCrater", this.realCrater);
        this.settings.setDouble("sizeOfMeteorite", this.squaredMeteoriteSize);
        this.settings.setDouble("crater", this.crater);
        this.settings.setBoolean("lava", Math.random() > 0.9);
        if (blk == Blocks.sand) {
            this.type = new FalloutSand(w, x, y, z, this.putter, this.skyStoneDefinition);
        } else if (blk == Blocks.hardened_clay) {
            this.type = new FalloutCopy(w, x, y, z, this.putter, this.skyStoneDefinition);
        } else if (blk == Blocks.ice || blk == Blocks.snow) {
            this.type = new FalloutSnow(w, x, y, z, this.putter, this.skyStoneDefinition);
        }
        int realValidBlocks = 0;
        for (int i = x - 6; i < x + 6; ++i) {
            for (int j = y - 6; j < y + 6; ++j) {
                for (int k = z - 6; k < z + 6; ++k) {
                    blk = w.getBlock(i, j, k);
                    if (!this.validSpawn.contains(blk)) continue;
                    ++realValidBlocks;
                }
            }
        }
        int validBlocks = 0;
        for (int i = x - 15; i < x + 15; ++i) {
            for (int j = y - 15; j < y + 15; ++j) {
                for (int k = z - 15; k < z + 15; ++k) {
                    blk = w.getBlock(i, j, k);
                    if (this.invalidSpawn.contains(blk)) {
                        return false;
                    }
                    if (!this.validSpawn.contains(blk)) continue;
                    ++validBlocks;
                }
            }
        }
        int minBLocks = 200;
        if (validBlocks > 200 && realValidBlocks > 80) {
            int j;
            int skyMode = 0;
            for (int i = x - 15; i < x + 15; ++i) {
                for (j = y - 15; j < y + 11; ++j) {
                    for (int k = z - 15; k < z + 15; ++k) {
                        if (!w.canBlockSeeTheSky(i, j, k)) continue;
                        ++skyMode;
                    }
                }
            }
            boolean solid = true;
            for (j = y - 15; j < y - 1; ++j) {
                if (w.getBlock(x, j, z) != Platform.AIR_BLOCK) continue;
                solid = false;
            }
            if (!solid) {
                skyMode = 0;
            }
            if (skyMode > 10) {
                this.placeCrater(w, x, y, z);
            }
            this.placeMeteorite(w, x, y, z);
            if (skyMode > 3) {
                this.decay(w, x, y, z);
            }
            this.settings.setInteger("skyMode", skyMode);
            w.done();
            WorldData.instance().spawnData().addNearByMeteorites(w.getWorld().provider.dimensionId, x >> 4, z >> 4, this.settings);
            return true;
        }
        return false;
    }

    NBTTagCompound getSettings() {
        return this.settings;
    }
}

