/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.LayerBase;
import appeng.parts.layers.InvLayerData;
import appeng.parts.layers.InvSot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class LayerISidedInventory
extends LayerBase
implements ISidedInventory {
    private static final int[] NULL_SIDES = new int[0];
    private InvLayerData invLayer = null;

    @Override
    public void notifyNeighbors() {
        ArrayList<ISidedInventory> inventories = new ArrayList<ISidedInventory>();
        int slotCount = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IPart bp = this.getPart(side);
            if (!(bp instanceof ISidedInventory)) continue;
            ISidedInventory part = (ISidedInventory)bp;
            slotCount += part.getSizeInventory();
            inventories.add(part);
        }
        ArrayList<InvSot> slots = null;
        Object sideData = null;
        if (inventories.isEmpty() || slotCount == 0) {
            inventories = null;
        } else {
            sideData = new int[][]{NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES};
            slots = new ArrayList<InvSot>(Collections.nCopies(slotCount, null));
            int offsetForLayer = 0;
            int offsetForPart = 0;
            for (ISidedInventory sides : inventories) {
                offsetForPart = 0;
                slotCount = sides.getSizeInventory();
                ForgeDirection currentSide = ForgeDirection.UNKNOWN;
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    if (this.getPart(side) != sides) continue;
                    currentSide = side;
                    break;
                }
                int[] nArray = new int[slotCount];
                sideData[currentSide.ordinal()] = nArray;
                int[] cSidesList = nArray;
                for (int cSlot = 0; cSlot < slotCount; ++cSlot) {
                    cSidesList[cSlot] = offsetForLayer;
                    slots.set(offsetForLayer, new InvSot(sides, offsetForPart));
                    ++offsetForLayer;
                    ++offsetForPart;
                }
            }
        }
        this.invLayer = sideData == null || slots == null ? null : new InvLayerData((int[][])sideData, (List<ISidedInventory>)inventories, (List<InvSot>)slots);
        super.notifyNeighbors();
    }

    public int getSizeInventory() {
        if (this.invLayer == null) {
            return 0;
        }
        return this.invLayer.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.invLayer == null) {
            return null;
        }
        return this.invLayer.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (this.invLayer == null) {
            return null;
        }
        return this.invLayer.decreaseStackSize(slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        if (this.invLayer == null) {
            return;
        }
        this.invLayer.setInventorySlotContents(slot, itemstack);
    }

    public String getInventoryName() {
        return "AEMultiPart";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.isItemValidForSlot(slot, itemstack);
    }

    public void markDirty() {
        if (this.invLayer != null) {
            this.invLayer.markDirty();
        }
        super.markForSave();
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (this.invLayer != null) {
            return this.invLayer.getAccessibleSlotsFromSide(side);
        }
        return NULL_SIDES;
    }

    public boolean canInsertItem(int slot, ItemStack itemstack, int side) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.canInsertItem(slot, itemstack, side);
    }

    public boolean canExtractItem(int slot, ItemStack itemstack, int side) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.canExtractItem(slot, itemstack, side);
    }
}

