/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.DimensionalCoord;
import appeng.block.misc.BlockTinyTNT;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.hooks.DispenserBlockTool;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.InWorldToolOperationResult;
import appeng.util.Platform;
import com.google.common.base.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ToolEntropyManipulator
extends AEBasePoweredItem
implements IBlockTool {
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> heatUp;
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> coolDown;

    public ToolEntropyManipulator() {
        super(AEConfig.instance.entropyManipulatorBattery, (Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.EntropyManipulator, AEFeature.PoweredTools));
        this.heatUp = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
        this.coolDown = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.stone, 0), new InWorldToolOperationResult(new ItemStack(Blocks.cobblestone)));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.stonebrick, 0), new InWorldToolOperationResult(new ItemStack(Blocks.stonebrick, 1, 2)));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.lava, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.obsidian)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.flowing_lava, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.obsidian)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.grass, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.dirt)));
        ArrayList<ItemStack> snowBalls = new ArrayList<ItemStack>();
        snowBalls.add(new ItemStack(Items.snowball));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.flowing_water, Short.MAX_VALUE), new InWorldToolOperationResult(null, snowBalls));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.water, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.ice)));
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.ice, 0), new InWorldToolOperationResult(new ItemStack(Blocks.water)));
        this.heatUp.put(new InWorldToolOperationIngredient((Block)Blocks.flowing_water, Short.MAX_VALUE), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.water, Short.MAX_VALUE), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.snow, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack((Block)Blocks.flowing_water)));
    }

    private static final boolean breakBlockWithCheck(World w, EntityPlayer p, int x, int y, int z) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, w, w.getBlock(x, y, z), w.getBlockMetadata(x, y, z), p);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled() && w.setBlockToAir(x, y, z);
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, (Object)new DispenserBlockTool());
    }

    private boolean heat(Block blockID, EntityPlayer p, int metadata, World w, int x, int y, int z) {
        if (!ToolEntropyManipulator.breakBlockWithCheck(w, p, x, y, z)) {
            return false;
        }
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        if (r.getBlockItem() != null) {
            w.setBlock(x, y, z, Block.getBlockFromItem((Item)r.getBlockItem().getItem()), r.getBlockItem().getItemDamage(), 3);
        }
        if (r.getDrops() != null) {
            Platform.spawnDrops(w, x, y, z, r.getDrops());
        }
        return true;
    }

    private boolean canHeat(Block blockID, int metadata) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        return r != null;
    }

    private boolean cool(Block blockID, EntityPlayer p, int metadata, World w, int x, int y, int z) {
        if (!ToolEntropyManipulator.breakBlockWithCheck(w, p, x, y, z)) {
            return false;
        }
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        if (r.getBlockItem() != null) {
            w.setBlock(x, y, z, Block.getBlockFromItem((Item)r.getBlockItem().getItem()), r.getBlockItem().getItemDamage(), 3);
        }
        if (r.getDrops() != null) {
            Platform.spawnDrops(w, x, y, z, r.getDrops());
        }
        return true;
    }

    private boolean canCool(Block blockID, int metadata) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        return r != null;
    }

    public boolean hitEntity(ItemStack item, EntityLivingBase target, EntityLivingBase hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0);
            target.setFire(8);
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack item, World w, EntityPlayer p) {
        int z;
        int y;
        int x;
        MovingObjectPosition target = this.getMovingObjectPositionFromPlayer(w, p, true);
        if (target == null) {
            return item;
        }
        if (target.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && (w.getBlock(x = target.blockX, y = target.blockY, z = target.blockZ).getMaterial() == Material.lava || w.getBlock(x, y, z).getMaterial() == Material.water) && Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
            this.onItemUse(item, p, w, x, y, z, 0, 0.0f, 0.0f, 0.0f);
        }
        return item;
    }

    @Override
    public boolean onItemUse(ItemStack item, EntityPlayer p, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.canPlayerEdit(x, y, z, side, item)) {
                return false;
            }
            Block blockID = w.getBlock(x, y, z);
            int metadata = w.getBlockMetadata(x, y, z);
            if (blockID == null || ForgeEventFactory.onPlayerInteract((EntityPlayer)p, (PlayerInteractEvent.Action)(blockID.isAir((IBlockAccess)w, x, y, z) ? PlayerInteractEvent.Action.RIGHT_CLICK_AIR : PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK), (int)x, (int)y, (int)z, (int)side, (World)w).isCanceled()) {
                return false;
            }
            if (p.isSneaking()) {
                if (this.canCool(blockID, metadata)) {
                    if (this.cool(blockID, p, metadata, w, x, y, z)) {
                        this.extractAEPower(item, 1600.0);
                        return true;
                    }
                    return false;
                }
            } else {
                if (blockID instanceof BlockTNT) {
                    if (!ToolEntropyManipulator.breakBlockWithCheck(w, p, x, y, z)) {
                        return false;
                    }
                    ((BlockTNT)blockID).func_150114_a(w, x, y, z, 1, (EntityLivingBase)p);
                    return true;
                }
                if (blockID instanceof BlockTinyTNT) {
                    if (!ToolEntropyManipulator.breakBlockWithCheck(w, p, x, y, z)) {
                        return false;
                    }
                    ((BlockTinyTNT)blockID).startFuse(w, x, y, z, (EntityLivingBase)p);
                    return true;
                }
                if (this.canHeat(blockID, metadata)) {
                    if (this.heat(blockID, p, metadata, w, x, y, z)) {
                        this.extractAEPower(item, 1600.0);
                        return true;
                    }
                    return false;
                }
                ItemStack[] stack = Platform.getBlockDrops(w, x, y, z);
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                boolean hasFurnaceable = false;
                boolean canFurnaceable = true;
                for (ItemStack i : stack) {
                    ItemStack result = FurnaceRecipes.smelting().getSmeltingResult(i);
                    if (result != null) {
                        if (result.getItem() instanceof ItemBlock && Block.getBlockFromItem((Item)result.getItem()) == blockID && result.getItem().getDamage(result) == metadata) {
                            canFurnaceable = false;
                        }
                        hasFurnaceable = true;
                        out.add(result);
                        continue;
                    }
                    canFurnaceable = false;
                    out.add(i);
                }
                if (hasFurnaceable && canFurnaceable) {
                    if (!ToolEntropyManipulator.breakBlockWithCheck(w, p, x, y, z)) {
                        return false;
                    }
                    this.extractAEPower(item, 1600.0);
                    InWorldToolOperationResult or = InWorldToolOperationResult.getBlockOperationResult(out.toArray(new ItemStack[out.size()]));
                    w.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
                    if (or.getBlockItem() != null) {
                        w.setBlock(x, y, z, Block.getBlockFromItem((Item)or.getBlockItem().getItem()), or.getBlockItem().getItemDamage(), 3);
                    }
                    if (or.getDrops() != null) {
                        Platform.spawnDrops(w, x, y, z, or.getDrops());
                    }
                    return true;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                if (!p.canPlayerEdit(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ, side, item)) {
                    return false;
                }
                if (w.isAirBlock(x, y, z)) {
                    this.extractAEPower(item, 1600.0);
                    w.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
                    w.setBlock(x, y, z, (Block)Blocks.fire);
                }
                return true;
            }
        }
        return false;
    }

    private static class InWorldToolOperationIngredient {
        private final Block blockID;
        private final int metadata;

        public InWorldToolOperationIngredient(Block blockID, int metadata) {
            this.blockID = blockID;
            this.metadata = metadata;
        }

        public int hashCode() {
            return this.blockID.hashCode() ^ this.metadata;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InWorldToolOperationIngredient other = (InWorldToolOperationIngredient)obj;
            return this.blockID == other.blockID && this.metadata == other.metadata;
        }
    }
}

