/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNEIRecipe;
import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NEICraftingHandler
implements IOverlayHandler {
    public NEICraftingHandler(int x, int y) {
    }

    public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        try {
            List ingredients = recipe.getIngredientStacks(recipeIndex);
            if (gui instanceof GuiCraftingTerm || gui instanceof GuiPatternTerm) {
                PacketNEIRecipe packet = new PacketNEIRecipe(this.packIngredients(gui, ingredients, false));
                if (packet.size() >= 32768) {
                    AELog.warn("Recipe for " + recipe.getRecipeName() + " has too many variants, reduced version will be used", new Object[0]);
                    packet = new PacketNEIRecipe(this.packIngredients(gui, ingredients, true));
                }
                NetworkHandler.instance.sendToServer(packet);
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private boolean testSize(NBTTagCompound recipe) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bytes);
        CompressedStreamTools.writeCompressed((NBTTagCompound)recipe, (OutputStream)outputStream);
        return bytes.size() > 3072;
    }

    private NBTTagCompound packIngredients(GuiContainer gui, List<PositionedStack> ingredients, boolean limited) throws IOException {
        NBTTagCompound recipe = new NBTTagCompound();
        block0: for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            for (Slot slot : gui.inventorySlots.inventorySlots) {
                if (!(slot instanceof SlotCraftingMatrix) && !(slot instanceof SlotFakeCraftingMatrix) || slot.getSlotIndex() != col + row * 3) continue;
                NBTTagList tags = new NBTTagList();
                LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                for (int x = 0; x < positionedStack.items.length; ++x) {
                    if (Platform.isRecipePrioritized(positionedStack.items[x])) {
                        list.add(0, positionedStack.items[x]);
                        continue;
                    }
                    list.add(positionedStack.items[x]);
                }
                for (ItemStack is : list) {
                    NBTTagCompound tag = new NBTTagCompound();
                    is.writeToNBT(tag);
                    tags.appendTag((NBTBase)tag);
                    if (!limited) continue;
                    NBTTagCompound test = new NBTTagCompound();
                    test.setTag("#" + slot.getSlotIndex(), (NBTBase)tags);
                    if (!this.testSize(test)) continue;
                    break;
                }
                recipe.setTag("#" + slot.getSlotIndex(), (NBTBase)tags);
                continue block0;
            }
        }
        return recipe;
    }
}

