/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.AEApi;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.sync.packets.PacketMockExplosion;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class EntityTinyTNTPrimed
extends EntityTNTPrimed
implements IEntityAdditionalSpawnData {
    public EntityTinyTNTPrimed(World w) {
        super(w);
        this.setSize(0.35f, 0.35f);
    }

    public EntityTinyTNTPrimed(World w, double x, double y, double z, EntityLivingBase igniter) {
        super(w, x, y, z, igniter);
        this.setSize(0.55f, 0.55f);
        this.yOffset = this.height / 2.0f;
    }

    public void onUpdate() {
        this.handleWaterMovement();
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
        }
        if (this.isInWater() && Platform.isServer()) {
            for (ItemStack tntStack : AEApi.instance().definitions().blocks().tinyTNT().maybeStack(1).asSet()) {
                EntityItem item = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, tntStack);
                item.motionX = this.motionX;
                item.motionY = this.motionY;
                item.motionZ = this.motionZ;
                item.prevPosX = this.prevPosX;
                item.prevPosY = this.prevPosY;
                item.prevPosZ = this.prevPosZ;
                this.worldObj.spawnEntityInWorld((Entity)item);
                this.setDead();
            }
        }
        if (this.fuse <= 0) {
            this.setDead();
            if (!this.worldObj.isRemote) {
                this.explode();
            }
        } else {
            this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
        }
        --this.fuse;
    }

    void explode() {
        this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "random.explode", 4.0f, (1.0f + (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.2f) * 32.9f);
        if (this.isInWater()) {
            return;
        }
        for (Object e : this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, AxisAlignedBB.getBoundingBox((double)(this.posX - 1.5), (double)(this.posY - 1.5), (double)(this.posZ - 1.5), (double)(this.posX + 1.5), (double)(this.posY + 1.5), (double)(this.posZ + 1.5)))) {
            if (!(e instanceof Entity)) continue;
            ((Entity)e).attackEntityFrom(DamageSource.setExplosionSource(null), 6.0f);
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.TinyTNTBlockDamage)) {
            this.posY -= 0.25;
            Explosion ex = new Explosion(this.worldObj, (Entity)this, this.posX, this.posY, this.posZ, 0.2f);
            int x = (int)(this.posX - 2.0);
            while ((double)x <= this.posX + 2.0) {
                int y = (int)(this.posY - 2.0);
                while ((double)y <= this.posY + 2.0) {
                    int z = (int)(this.posZ - 2.0);
                    while ((double)z <= this.posZ + 2.0) {
                        Block block = this.worldObj.getBlock(x, y, z);
                        if (block != null && !block.isAir((IBlockAccess)this.worldObj, x, y, z)) {
                            float strength = (float)((double)2.3f - (((double)((float)x + 0.5f) - this.posX) * ((double)((float)x + 0.5f) - this.posX) + ((double)((float)y + 0.5f) - this.posY) * ((double)((float)y + 0.5f) - this.posY) + ((double)((float)z + 0.5f) - this.posZ) * ((double)((float)z + 0.5f) - this.posZ)));
                            float resistance = block.getExplosionResistance((Entity)this, this.worldObj, x, y, z, this.posX, this.posY, this.posZ);
                            if ((double)(strength -= (resistance + 0.3f) * 0.11f) > 0.01 && block.getMaterial() != Material.air) {
                                if (block.canDropFromExplosion(ex)) {
                                    block.dropBlockAsItemWithChance(this.worldObj, x, y, z, this.worldObj.getBlockMetadata(x, y, z), 1.0f, 0);
                                }
                                block.onBlockExploded(this.worldObj, x, y, z, ex);
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        CommonHelper.proxy.sendToAllNearExcept(null, this.posX, this.posY, this.posZ, 64.0, this.worldObj, new PacketMockExplosion(this.posX, this.posY, this.posZ));
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.fuse);
    }

    public void readSpawnData(ByteBuf data) {
        this.fuse = data.readByte();
    }
}

