/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.storage.ITerminalHost;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.container.implementations.CraftingCPURecord;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;

public class ContainerCraftingStatus
extends ContainerCraftingCPU {
    private final List<CraftingCPURecord> cpus = new ArrayList<CraftingCPURecord>();
    @GuiSync(value=5)
    public int selectedCpu = -1;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public String myName = "";

    public ContainerCraftingStatus(InventoryPlayer ip, ITerminalHost te) {
        super(ip, te);
    }

    @Override
    public void detectAndSendChanges() {
        if (Platform.isServer() && this.getNetwork() != null) {
            ICraftingGrid cc = (ICraftingGrid)this.getNetwork().getCache(ICraftingGrid.class);
            ImmutableSet<ICraftingCPU> cpuSet = cc.getCpus();
            int matches = 0;
            boolean changed = false;
            for (ICraftingCPU c : cpuSet) {
                boolean found = false;
                for (CraftingCPURecord ccr : this.cpus) {
                    if (ccr.getCpu() != c) continue;
                    found = true;
                }
                boolean matched = this.cpuMatches(c);
                if (matched) {
                    ++matches;
                }
                if (found != !matched) continue;
                changed = true;
            }
            if (changed || this.cpus.size() != matches) {
                this.cpus.clear();
                for (ICraftingCPU c : cpuSet) {
                    if (!this.cpuMatches(c)) continue;
                    this.cpus.add(new CraftingCPURecord(c.getAvailableStorage(), c.getCoProcessors(), c));
                }
                this.sendCPUs();
            }
            this.noCPU = this.cpus.isEmpty();
        }
        super.detectAndSendChanges();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.isBusy();
    }

    private void sendCPUs() {
        Collections.sort(this.cpus);
        if (this.selectedCpu >= this.cpus.size()) {
            this.selectedCpu = -1;
            this.myName = "";
        } else if (this.selectedCpu != -1) {
            this.myName = this.cpus.get(this.selectedCpu).getName();
        }
        if (this.selectedCpu == -1 && this.cpus.size() > 0) {
            this.selectedCpu = 0;
        }
        if (this.selectedCpu != -1) {
            if (this.cpus.get(this.selectedCpu).getCpu() != this.getMonitor()) {
                this.setCPU(this.cpus.get(this.selectedCpu).getCpu());
            }
        } else {
            this.setCPU(null);
        }
    }

    public void cycleCpu(boolean next) {
        this.selectedCpu = next ? ++this.selectedCpu : --this.selectedCpu;
        if (this.selectedCpu < -1) {
            this.selectedCpu = this.cpus.size() - 1;
        } else if (this.selectedCpu >= this.cpus.size()) {
            this.selectedCpu = -1;
        }
        if (this.selectedCpu == -1 && this.cpus.size() > 0) {
            this.selectedCpu = 0;
        }
        if (this.selectedCpu == -1) {
            this.myName = "";
            this.setCPU(null);
        } else {
            this.myName = this.cpus.get(this.selectedCpu).getName();
            this.setCPU(this.cpus.get(this.selectedCpu).getCpu());
        }
    }
}

