/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.spatial.BlockSpatialPylon;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.spatial.TileSpatialPylon;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderSpatialPylon
extends BaseBlockRender<BlockSpatialPylon, TileSpatialPylon> {
    public RenderSpatialPylon() {
        super(false, 0.0);
    }

    @Override
    public void renderInventory(BlockSpatialPylon block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        renderer.overrideBlockTexture = ExtraBlockTextures.BlockSpatialPylon_dim.getIcon();
        super.renderInventory(block, is, renderer, type, obj);
        renderer.overrideBlockTexture = null;
        super.renderInventory(block, is, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(BlockSpatialPylon imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        int displayBits;
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        TileSpatialPylon sp = (TileSpatialPylon)imb.getTileEntity(world, x, y, z);
        int n = displayBits = sp == null ? 0 : sp.getDisplayBits();
        if (displayBits != 0) {
            ForgeDirection ori = ForgeDirection.UNKNOWN;
            if ((displayBits & 0xC) == 4) {
                ori = ForgeDirection.EAST;
                if ((displayBits & 3) == 2) {
                    renderer.uvRotateEast = 1;
                    renderer.uvRotateWest = 2;
                    renderer.uvRotateTop = 2;
                    renderer.uvRotateBottom = 1;
                } else if ((displayBits & 3) == 1) {
                    renderer.uvRotateEast = 2;
                    renderer.uvRotateWest = 1;
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 2;
                } else {
                    renderer.uvRotateEast = 1;
                    renderer.uvRotateWest = 1;
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 1;
                }
            } else if ((displayBits & 0xC) == 8) {
                ori = ForgeDirection.UP;
                if ((displayBits & 3) == 2) {
                    renderer.uvRotateNorth = 3;
                    renderer.uvRotateSouth = 3;
                    renderer.uvRotateEast = 3;
                    renderer.uvRotateWest = 3;
                }
            } else if ((displayBits & 0xC) == 12) {
                ori = ForgeDirection.NORTH;
                if ((displayBits & 3) == 2) {
                    renderer.uvRotateSouth = 1;
                    renderer.uvRotateNorth = 2;
                } else if ((displayBits & 3) == 1) {
                    renderer.uvRotateNorth = 1;
                    renderer.uvRotateSouth = 2;
                    renderer.uvRotateTop = 3;
                    renderer.uvRotateBottom = 3;
                } else {
                    renderer.uvRotateNorth = 1;
                    renderer.uvRotateSouth = 2;
                }
            }
            BlockRenderInfo bri = imb.getRendererInstance();
            bri.setTemporaryRenderIcon(null);
            bri.setTemporaryRenderIcons(this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.UP), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.DOWN), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.SOUTH), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.NORTH), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.EAST), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.WEST));
            boolean r = renderer.renderStandardBlock((Block)imb, x, y, z);
            if ((displayBits & 0x20) == 32) {
                int bn = 15;
                Tessellator.instance.setBrightness(0xF000F0);
                Tessellator.instance.setColorOpaque_I(0xFFFFFF);
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(x, y, z, imb, this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, d), renderer, d);
                }
            } else {
                bri.setTemporaryRenderIcon(null);
                bri.setTemporaryRenderIcons(this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.UP), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.DOWN), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.SOUTH), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.NORTH), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.EAST), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.WEST));
                renderer.renderStandardBlock((Block)imb, x, y, z);
            }
            bri.setTemporaryRenderIcon(null);
            renderer.uvRotateBottom = 0;
            renderer.uvRotateTop = 0;
            renderer.uvRotateSouth = 0;
            renderer.uvRotateNorth = 0;
            renderer.uvRotateWest = 0;
            renderer.uvRotateEast = 0;
            return r;
        }
        renderer.overrideBlockTexture = imb.getIcon(0, 0);
        boolean result = renderer.renderStandardBlock((Block)imb, x, y, z);
        renderer.overrideBlockTexture = ExtraBlockTextures.BlockSpatialPylon_dim.getIcon();
        result = renderer.renderStandardBlock((Block)imb, x, y, z);
        renderer.overrideBlockTexture = null;
        return result;
    }

    private IIcon getBlockTextureFromSideOutside(BlockSpatialPylon blk, TileSpatialPylon sp, int displayBits, ForgeDirection ori, ForgeDirection dir) {
        if (ori == dir || ori.getOpposite() == dir) {
            return blk.getRendererInstance().getTexture(dir);
        }
        if ((displayBits & 3) == 3) {
            return ExtraBlockTextures.BlockSpatialPylonC.getIcon();
        }
        if ((displayBits & 3) == 1) {
            return ExtraBlockTextures.BlockSpatialPylonE.getIcon();
        }
        if ((displayBits & 3) == 2) {
            return ExtraBlockTextures.BlockSpatialPylonE.getIcon();
        }
        return blk.getIcon(0, 0);
    }

    private IIcon getBlockTextureFromSideInside(BlockSpatialPylon blk, TileSpatialPylon sp, int displayBits, ForgeDirection ori, ForgeDirection dir) {
        boolean good;
        boolean bl = good = (displayBits & 0x10) == 16;
        if (ori == dir || ori.getOpposite() == dir) {
            return good ? ExtraBlockTextures.BlockSpatialPylon_dim.getIcon() : ExtraBlockTextures.BlockSpatialPylon_red.getIcon();
        }
        if ((displayBits & 3) == 3) {
            return good ? ExtraBlockTextures.BlockSpatialPylonC_dim.getIcon() : ExtraBlockTextures.BlockSpatialPylonC_red.getIcon();
        }
        if ((displayBits & 3) == 1) {
            return good ? ExtraBlockTextures.BlockSpatialPylonE_dim.getIcon() : ExtraBlockTextures.BlockSpatialPylonE_red.getIcon();
        }
        if ((displayBits & 3) == 2) {
            return good ? ExtraBlockTextures.BlockSpatialPylonE_dim.getIcon() : ExtraBlockTextures.BlockSpatialPylonE_red.getIcon();
        }
        return blk.getIcon(0, 0);
    }
}

