/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.AEApi;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderBlockSkyChest;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.helpers.ICustomCollision;
import appeng.tile.storage.TileSkyChest;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSkyChest
extends AEBaseTileBlock
implements ICustomCollision {
    private static final double AABB_OFFSET_BOTTOM = 0.0625;
    private static final double AABB_OFFSET_SIDES = 0.0;
    private static final double AABB_OFFSET_TOP = 0.125;

    public BlockSkyChest() {
        super(Material.rock);
        this.setTileEntity(TileSkyChest.class);
        this.isFullSize = false;
        this.isOpaque = false;
        this.hasSubtypes = true;
        this.lightOpacity = 0;
        this.setHardness(50.0f);
        this.blockResistance = 150.0f;
        this.setFeature(EnumSet.of(AEFeature.Core, AEFeature.SkyStoneChests));
    }

    public int damageDropped(int metadata) {
        return metadata;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack is = super.getPickBlock(target, world, x, y, z, player);
        is.setItemDamage(world.getBlockMetadata(x, y, z));
        return is;
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockSkyChest getRenderer() {
        return new RenderBlockSkyChest();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int direction, int metadata) {
        Iterator iterator = AEApi.instance().definitions().blocks().skyStone().maybeBlock().asSet().iterator();
        if (iterator.hasNext()) {
            Block skyStoneBlock = (Block)iterator.next();
            return skyStoneBlock.getIcon(direction, metadata);
        }
        return Blocks.stone.getIcon(direction, metadata);
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (Platform.isServer()) {
            Platform.openGUI(player, this.getTileEntity((IBlockAccess)w, x, y, z), ForgeDirection.getOrientation((int)side), GuiBridge.GUI_SKYCHEST);
        }
        return true;
    }

    @Override
    public void registerBlockIcons(IIconRegister iconRegistry) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getCheckedSubBlocks(item, tabs, itemStacks);
        itemStacks.add(new ItemStack(item, 1, 1));
    }

    @Override
    public String getUnlocalizedName(ItemStack is) {
        if (is.getItemDamage() == 1) {
            return this.getUnlocalizedName() + ".Block";
        }
        return this.getUnlocalizedName();
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity thePlayer, boolean isVisual) {
        return Collections.singletonList(this.computeAABB(w, x, y, z));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        out.add(this.computeAABB(w, x, y, z));
    }

    private AxisAlignedBB computeAABB(World w, int x, int y, int z) {
        TileSkyChest sk = (TileSkyChest)this.getTileEntity((IBlockAccess)w, x, y, z);
        ForgeDirection o = ForgeDirection.UP;
        if (sk != null) {
            o = sk.getUp();
        }
        double offsetX = o.offsetX == 0 ? 0.0625 : 0.0;
        double offsetY = o.offsetY == 0 ? 0.0625 : 0.0;
        double offsetZ = o.offsetZ == 0 ? 0.0625 : 0.0;
        double minX = Math.max(0.0, offsetX + (double)o.offsetX * 0.125);
        double minY = Math.max(0.0, offsetY - (double)o.offsetY * 0.125);
        double minZ = Math.max(0.0, offsetZ + (double)o.offsetZ * 0.125);
        double maxX = Math.min(1.0, 1.0 - offsetX + (double)o.offsetX * 0.125);
        double maxY = Math.min(1.0, 1.0 - offsetY - (double)o.offsetY * 0.125);
        double maxZ = Math.min(1.0, 1.0 - offsetZ + (double)o.offsetZ * 0.125);
        return AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

