/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderBlockWireless;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.networking.TileWireless;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWireless
extends AEBaseTileBlock
implements ICustomCollision {
    public BlockWireless() {
        super(AEGlassMaterial.INSTANCE);
        this.setTileEntity(TileWireless.class);
        this.setLightOpacity(0);
        this.isFullSize = false;
        this.isOpaque = false;
        this.setFeature(EnumSet.of(AEFeature.Core, AEFeature.WirelessAccessTerminal));
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockWireless getRenderer() {
        return new RenderBlockWireless();
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        TileWireless tg = (TileWireless)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tg != null && !p.isSneaking()) {
            if (Platform.isServer()) {
                Platform.openGUI(p, tg, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_WIRELESS);
            }
            return true;
        }
        return super.onBlockActivated(w, x, y, z, p, side, hitX, hitY, hitZ);
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        TileWireless tile = (TileWireless)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile != null) {
            ForgeDirection forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 1.0;
                    minY = 0.3125;
                    break;
                }
                case EAST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 0.6875;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 1.0;
                    minZ = 0.3125;
                    break;
                }
                case SOUTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 0.6875;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 0.6875;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 1.0;
                    minX = 0.3125;
                    break;
                }
            }
            return Collections.singletonList(AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        }
        return Collections.singletonList(AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        TileWireless tile = (TileWireless)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile != null) {
            ForgeDirection forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 1.0;
                    minY = 0.3125;
                    break;
                }
                case EAST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 0.6875;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 1.0;
                    minZ = 0.3125;
                    break;
                }
                case SOUTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 0.6875;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 0.6875;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 1.0;
                    minX = 0.3125;
                    break;
                }
            }
            out.add(AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        } else {
            out.add(AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        }
    }
}

