/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.storage.DriveWatcher;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileDrive
extends AENetworkInvTile
implements IChestOrDrive,
IPriorityHost {
    private final int[] sides = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 10);
    private final ICellHandler[] handlersBySlot = new ICellHandler[10];
    private final DriveWatcher<IAEItemStack>[] invBySlot = new DriveWatcher[10];
    private final BaseActionSource mySrc;
    private boolean isCached = false;
    private List<MEInventoryHandler> items = new LinkedList<MEInventoryHandler>();
    private List<MEInventoryHandler> fluids = new LinkedList<MEInventoryHandler>();
    private long lastStateChange = 0L;
    private int state = 0;
    private int priority = 0;
    private boolean wasActive = false;

    public TileDrive() {
        this.mySrc = new MachineSource(this);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileDrive(ByteBuf data) {
        this.state = this.worldObj.getTotalWorldTime() - this.lastStateChange > 8L ? 0 : (this.state &= 0x24924924);
        this.state = this.getProxy().isActive() ? (this.state |= Integer.MIN_VALUE) : (this.state &= Integer.MAX_VALUE);
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x) << 3 * x;
        }
        data.writeInt(this.state);
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.state >> slot * 3 & 3;
        }
        ItemStack cell = this.inv.getStackInSlot(2);
        ICellHandler ch = this.handlersBySlot[slot];
        DriveWatcher<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return 0;
        }
        if (handler.getChannel() == StorageChannel.ITEMS && ch != null) {
            return ch.getStatusForCell(cell, handler.getInternal());
        }
        if (handler.getChannel() == StorageChannel.FLUIDS && ch != null) {
            return ch.getStatusForCell(cell, handler.getInternal());
        }
        return 0;
    }

    @Override
    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isCellBlinking(int slot) {
        long now = this.worldObj.getTotalWorldTime();
        if (now - this.lastStateChange > 8L) {
            return false;
        }
        return (this.state >> slot * 3 + 2 & 1) == 1;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileDrive(ByteBuf data) {
        int oldState = this.state;
        this.state = data.readInt();
        this.lastStateChange = this.worldObj.getTotalWorldTime();
        return (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileDrive(NBTTagCompound data) {
        this.isCached = false;
        this.priority = data.getInteger("priority");
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileDrive(NBTTagCompound data) {
        data.setInteger("priority", this.priority);
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    private void recalculateDisplay() {
        boolean currentActive = this.getProxy().isActive();
        this.state = currentActive ? (this.state |= Integer.MIN_VALUE) : (this.state &= Integer.MAX_VALUE);
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x) << 3 * x;
        }
        boolean oldState = false;
        if (0 != this.state) {
            this.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return itemstack != null && AEApi.instance().registries().cell().isCellHandled(itemstack);
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            IStorageGrid gs = this.getProxy().getStorage();
            Platform.postChanges(gs, removed, added, this.mySrc);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    private void updateState() {
        if (!this.isCached) {
            this.items = new LinkedList<MEInventoryHandler>();
            this.fluids = new LinkedList<MEInventoryHandler>();
            double power = 2.0;
            for (int x = 0; x < this.inv.getSizeInventory(); ++x) {
                DriveWatcher ih;
                ItemStack is = this.inv.getStackInSlot(x);
                this.invBySlot[x] = null;
                this.handlersBySlot[x] = null;
                if (is == null) continue;
                this.handlersBySlot[x] = AEApi.instance().registries().cell().getHandler(is);
                if (this.handlersBySlot[x] == null) continue;
                IMEInventoryHandler cell = this.handlersBySlot[x].getCellInventory(is, this, StorageChannel.ITEMS);
                if (cell != null) {
                    power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                    ih = new DriveWatcher(cell, is, this.handlersBySlot[x], this);
                    ih.setPriority(this.priority);
                    this.invBySlot[x] = ih;
                    this.items.add(ih);
                    continue;
                }
                cell = this.handlersBySlot[x].getCellInventory(is, this, StorageChannel.FLUIDS);
                if (cell == null) continue;
                power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                ih = new DriveWatcher(cell, is, this.handlersBySlot[x], this);
                ih.setPriority(this.priority);
                this.invBySlot[x] = ih;
                this.fluids.add(ih);
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive()) {
            this.updateState();
            return channel == StorageChannel.ITEMS ? this.items : this.fluids;
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.markDirty();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        long now = this.worldObj.getTotalWorldTime();
        if (now - this.lastStateChange > 8L) {
            this.state = 0;
        }
        this.lastStateChange = now;
        this.state |= 1 << slot * 3 + 2;
        this.recalculateDisplay();
    }

    @Override
    public void saveChanges(IMEInventory cellInventory) {
        this.worldObj.markTileEntityChunkModified(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
    }
}

