/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IParts;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.PartBasicState;
import appeng.util.Platform;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class PartP2PTunnel<T extends PartP2PTunnel>
extends PartBasicState {
    private final TunnelCollection type = new TunnelCollection(null, this.getClass());
    private boolean output;
    private long freq;

    public PartP2PTunnel(ItemStack is) {
        super(is);
    }

    public TunnelCollection<T> getCollection(Collection<PartP2PTunnel> collection, Class<? extends PartP2PTunnel> c) {
        if (this.type.matches(c)) {
            this.type.setSource(collection);
            return this.type;
        }
        return null;
    }

    public T getInput() {
        if (this.getFrequency() == 0L) {
            return null;
        }
        try {
            PartP2PTunnel tunnel = this.getProxy().getP2P().getInput(this.getFrequency());
            if (this.getClass().isInstance(tunnel)) {
                return (T)tunnel;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return null;
    }

    public TunnelCollection<T> getOutputs() throws GridAccessException {
        if (this.getProxy().isActive()) {
            return this.getProxy().getP2P().getOutputs(this.getFrequency(), this.getClass());
        }
        return new TunnelCollection(new ArrayList(), this.getClass());
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(this.getTypeTexture());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.BlockP2PTunnel2.getIcon(), this.getItemStack().getIconIndex(), CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.PartTunnelSides.getIcon());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
    }

    protected IIcon getTypeTexture() {
        Optional<Block> maybeBlock = AEApi.instance().definitions().blocks().quartz().maybeBlock();
        if (maybeBlock.isPresent()) {
            return ((Block)maybeBlock.get()).getIcon(0, 0);
        }
        return Blocks.quartz_block.getIcon(0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, this, this.getRenderCache()));
        rh.setTexture(this.getTypeTexture());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.BlockP2PTunnel2.getIcon(), this.getItemStack().getIconIndex(), CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.PartTunnelSides.getIcon());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(3.0f, 3.0f, 13.0f, 13.0f, 13.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.BlockP2PTunnel3.getIcon());
        rh.setBounds(6.0f, 5.0f, 12.0f, 10.0f, 11.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 6.0f, 12.0f, 11.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        if (type == PartItemStack.World || type == PartItemStack.Network || type == PartItemStack.Wrench || type == PartItemStack.Pick) {
            return super.getItemStack(type);
        }
        Optional<ItemStack> maybeMEStack = AEApi.instance().definitions().parts().p2PTunnelME().maybeStack(1);
        if (maybeMEStack.isPresent()) {
            return (ItemStack)maybeMEStack.get();
        }
        return super.getItemStack(type);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setOutput(data.getBoolean("output"));
        this.setFrequency(data.getLong("freq"));
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("output", this.isOutput());
        data.setLong("freq", this.getFrequency());
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    @Override
    public boolean useStandardMemoryCard() {
        return false;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        ItemStack is = player.inventory.getCurrentItem();
        TunnelType tt = AEApi.instance().registries().p2pTunnel().getTunnelTypeByItem(is);
        if (is != null && is.getItem() instanceof IMemoryCard) {
            IPart testPart;
            if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
                return false;
            }
            IMemoryCard mc = (IMemoryCard)is.getItem();
            NBTTagCompound data = mc.getData(is);
            ItemStack newType2 = ItemStack.loadItemStackFromNBT((NBTTagCompound)data);
            long freq = data.getLong("freq");
            if (newType2 != null && newType2.getItem() instanceof IPartItem && (testPart = ((IPartItem)newType2.getItem()).createPartFromItemStack(newType2)) instanceof PartP2PTunnel) {
                this.getHost().removePart(this.getSide(), true);
                ForgeDirection dir = this.getHost().addPart(newType2, this.getSide(), player);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof PartP2PTunnel) {
                    PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                    newTunnel.setOutput(true);
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, freq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    newTunnel.onTunnelNetworkChange();
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
        } else if (tt != null) {
            ItemStack newType = null;
            IParts parts = AEApi.instance().definitions().parts();
            switch (tt) {
                case LIGHT: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelLight().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
                case RF_POWER: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelRF().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
                case FLUID: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelLiquids().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
                case IC2_POWER: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelEU().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
                case ITEM: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelItems().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
                case ME: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelME().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
                case REDSTONE: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelRedstone().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
                case COMPUTER_MESSAGE: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelOpenComputers().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
                case PRESSURE: {
                    ItemStack stack;
                    Iterator newType2 = parts.p2PTunnelPneumaticCraft().maybeStack(1).asSet().iterator();
                    while (newType2.hasNext()) {
                        newType = stack = (ItemStack)newType2.next();
                    }
                    break;
                }
            }
            if (newType != null && !Platform.isSameItem(newType, this.getItemStack())) {
                boolean oldOutput = this.isOutput();
                long myFreq = this.getFrequency();
                this.getHost().removePart(this.getSide(), false);
                ForgeDirection dir = this.getHost().addPart(newType, this.getSide(), player);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof PartP2PTunnel) {
                    PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                    newTunnel.setOutput(oldOutput);
                    newTunnel.onTunnelNetworkChange();
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, myFreq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                Platform.notifyBlocksOfNeighbors(this.getTile().getWorldObj(), this.getTile().xCoord, this.getTile().yCoord, this.getTile().zCoord);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, Vec3 pos) {
        ItemStack is = player.inventory.getCurrentItem();
        if (is != null && is.getItem() instanceof IMemoryCard) {
            if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
                return false;
            }
            IMemoryCard mc = (IMemoryCard)is.getItem();
            NBTTagCompound data = new NBTTagCompound();
            long newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            if (wasOutput || this.getFrequency() == 0L) {
                newFreq = System.currentTimeMillis();
            }
            try {
                this.getProxy().getP2P().updateFreq(this, newFreq);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            this.onTunnelConfigChange();
            ItemStack p2pItem = this.getItemStack(PartItemStack.Wrench);
            String type = p2pItem.getUnlocalizedName();
            p2pItem.writeToNBT(data);
            data.setLong("freq", this.getFrequency());
            mc.setMemoryCardContents(is, type + ".name", data);
            mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            return true;
        }
        return false;
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingTexture() {
        return CableBusTextures.BlockP2PTunnel2.getIcon();
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        try {
            this.getProxy().getEnergy().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public long getFrequency() {
        return this.freq;
    }

    public void setFrequency(long freq) {
        this.freq = freq;
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
    }
}

