/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.AEBaseContainer;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPartialItem
extends AppEngPacket {
    private final short pageNum;
    private final byte[] data;

    public PacketPartialItem(ByteBuf stream) {
        this.pageNum = stream.readShort();
        this.data = new byte[stream.readableBytes()];
        stream.readBytes(this.data);
    }

    public PacketPartialItem(int page, int maxPages, byte[] buf) {
        ByteBuf data = Unpooled.buffer();
        this.pageNum = (short)(page | maxPages << 8);
        this.data = buf;
        data.writeInt(this.getPacketID());
        data.writeShort((int)this.pageNum);
        data.writeBytes(buf);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        if (player.openContainer instanceof AEBaseContainer) {
            ((AEBaseContainer)player.openContainer).postPartial(this);
        }
    }

    public int getPageCount() {
        return this.pageNum >> 8;
    }

    public int getSize() {
        return this.data.length;
    }

    public int write(byte[] buffer, int cursor) {
        System.arraycopy(this.data, 0, buffer, cursor, this.data.length);
        return cursor + this.data.length;
    }
}

