/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.misc.BlockPaint;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.helpers.Splotch;
import appeng.tile.misc.TilePaint;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderBlockPaint
extends BaseBlockRender<BlockPaint, TilePaint> {
    public RenderBlockPaint() {
        super(false, 0.0);
    }

    @Override
    public void renderInventory(BlockPaint block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
    }

    @Override
    public boolean renderInWorld(BlockPaint imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TilePaint tp = (TilePaint)imb.getTileEntity(world, x, y, z);
        boolean out = false;
        if (tp != null) {
            IIcon[] icoSet = new IIcon[]{imb.getIcon(0, 0), ExtraBlockTextures.BlockPaint2.getIcon(), ExtraBlockTextures.BlockPaint3.getIcon()};
            Tessellator tess = Tessellator.instance;
            int brightness = imb.getMixedBrightnessForBlock(world, x, y, z);
            EnumSet<ForgeDirection> validSides = EnumSet.noneOf(ForgeDirection.class);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!tp.isSideValid(side)) continue;
                validSides.add(side);
            }
            double offsetConstant = 0.001;
            int lumen = 0xE000E0;
            for (Splotch s : tp.getDots()) {
                if (!validSides.contains(s.getSide())) continue;
                if (s.isLumen()) {
                    tess.setColorOpaque_I(s.getColor().whiteVariant);
                    tess.setBrightness(0xE000E0);
                } else {
                    tess.setColorOpaque_I(s.getColor().mediumVariant);
                    tess.setBrightness(brightness);
                }
                double offset = offsetConstant;
                offsetConstant += 0.001;
                double buffer = 0.1;
                double pos_x = s.x();
                double pos_y = s.y();
                pos_x = Math.max(0.1, Math.min(0.9, pos_x));
                pos_y = Math.max(0.1, Math.min(0.9, pos_y));
                if (s.getSide() == ForgeDirection.SOUTH || s.getSide() == ForgeDirection.NORTH) {
                    pos_x += (double)x;
                    pos_y += (double)y;
                } else if (s.getSide() == ForgeDirection.UP || s.getSide() == ForgeDirection.DOWN) {
                    pos_x += (double)x;
                    pos_y += (double)z;
                } else {
                    pos_x += (double)y;
                    pos_y += (double)z;
                }
                IIcon ico = icoSet[s.getSeed() % icoSet.length];
                switch (s.getSide()) {
                    case UP: {
                        offset = 1.0 - offset;
                        tess.addVertexWithUV(pos_x - 0.1, (double)y + offset, pos_y - 0.1, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x + 0.1, (double)y + offset, pos_y - 0.1, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x + 0.1, (double)y + offset, pos_y + 0.1, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV(pos_x - 0.1, (double)y + offset, pos_y + 0.1, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case DOWN: {
                        tess.addVertexWithUV(pos_x + 0.1, (double)y + offset, pos_y - 0.1, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x - 0.1, (double)y + offset, pos_y - 0.1, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x - 0.1, (double)y + offset, pos_y + 0.1, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV(pos_x + 0.1, (double)y + offset, pos_y + 0.1, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case EAST: {
                        offset = 1.0 - offset;
                        tess.addVertexWithUV((double)x + offset, pos_x + 0.1, pos_y - 0.1, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV((double)x + offset, pos_x - 0.1, pos_y - 0.1, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV((double)x + offset, pos_x - 0.1, pos_y + 0.1, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV((double)x + offset, pos_x + 0.1, pos_y + 0.1, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case WEST: {
                        tess.addVertexWithUV((double)x + offset, pos_x - 0.1, pos_y - 0.1, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV((double)x + offset, pos_x + 0.1, pos_y - 0.1, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV((double)x + offset, pos_x + 0.1, pos_y + 0.1, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV((double)x + offset, pos_x - 0.1, pos_y + 0.1, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case SOUTH: {
                        offset = 1.0 - offset;
                        tess.addVertexWithUV(pos_x + 0.1, pos_y - 0.1, (double)z + offset, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x - 0.1, pos_y - 0.1, (double)z + offset, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x - 0.1, pos_y + 0.1, (double)z + offset, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV(pos_x + 0.1, pos_y + 0.1, (double)z + offset, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case NORTH: {
                        tess.addVertexWithUV(pos_x - 0.1, pos_y - 0.1, (double)z + offset, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x + 0.1, pos_y - 0.1, (double)z + offset, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x + 0.1, pos_y + 0.1, (double)z + offset, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV(pos_x - 0.1, pos_y + 0.1, (double)z + offset, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                }
            }
            out = true;
        }
        return out;
    }
}

