/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkControllerChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileController
extends AENetworkPowerTile {
    private static final IInventory NULL_INVENTORY = new AppEngInternalInventory(null, 0);
    private static final int[] ACCESSIBLE_SLOTS_BY_SIDE = new int[0];
    private boolean isValid = false;

    public TileController() {
        this.setInternalMaxPower(8000.0);
        this.setInternalPublicPowerStorage(true);
        this.getProxy().setIdlePowerUsage(3.0);
        this.getProxy().setFlags(GridFlags.CANNOT_CARRY, GridFlags.DENSE_CAPACITY);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    @Override
    public void onReady() {
        this.onNeighborChange(true);
        super.onReady();
    }

    public void onNeighborChange(boolean force) {
        boolean xx = this.checkController(this.xCoord - 1, this.yCoord, this.zCoord) && this.checkController(this.xCoord + 1, this.yCoord, this.zCoord);
        boolean yy = this.checkController(this.xCoord, this.yCoord - 1, this.zCoord) && this.checkController(this.xCoord, this.yCoord + 1, this.zCoord);
        boolean zz = this.checkController(this.xCoord, this.yCoord, this.zCoord - 1) && this.checkController(this.xCoord, this.yCoord, this.zCoord + 1);
        boolean oldValid = this.isValid;
        boolean bl = xx && !yy && !zz || !xx && yy && !zz || !xx && !yy && zz || (xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) <= 1 ? true : (this.isValid = false);
        if (oldValid != this.isValid || force) {
            if (this.isValid) {
                this.getProxy().setValidSides(EnumSet.allOf(ForgeDirection.class));
            } else {
                this.getProxy().setValidSides(EnumSet.noneOf(ForgeDirection.class));
            }
            this.updateMeta();
        }
    }

    private void updateMeta() {
        if (!this.getProxy().isReady()) {
            return;
        }
        int meta = 0;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                meta = 1;
                if (this.getProxy().getPath().getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                    meta = 2;
                }
            }
        }
        catch (GridAccessException e) {
            meta = 0;
        }
        if (this.checkController(this.xCoord, this.yCoord, this.zCoord) && this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord) != meta) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, meta, 2);
        }
    }

    @Override
    protected double getFunnelPowerDemand(double maxReceived) {
        try {
            return this.getProxy().getEnergy().getEnergyDemand(8000.0);
        }
        catch (GridAccessException e) {
            return super.getFunnelPowerDemand(maxReceived);
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        try {
            double ret = this.getProxy().getEnergy().injectPower(power, mode);
            if (mode == Actionable.SIMULATE) {
                return ret;
            }
            return 0.0;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(power, mode);
        }
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        try {
            this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, x));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void onControllerChange(MENetworkControllerChange status) {
        this.updateMeta();
    }

    @MENetworkEventSubscribe
    public void onPowerChange(MENetworkPowerStatusChange status) {
        this.updateMeta();
    }

    @Override
    public IInventory getInternalInventory() {
        return NULL_INVENTORY;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return ACCESSIBLE_SLOTS_BY_SIDE;
    }

    private boolean checkController(int x, int y, int z) {
        if (this.worldObj.getChunkProvider().chunkExists(this.xCoord >> 4, this.zCoord >> 4)) {
            return this.worldObj.getTileEntity(x, y, z) instanceof TileController;
        }
        return false;
    }
}

