/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.util.Platform;

public class TileLightDetector
extends AEBaseTile {
    private int lastCheck = 30;
    private int lastLight = 0;

    public boolean isReady() {
        return this.lastLight > 0;
    }

    @TileEvent(value=TileEventType.TICK)
    public void Tick_TileLightDetector() {
        ++this.lastCheck;
        if (this.lastCheck > 30) {
            this.lastCheck = 0;
            this.updateLight();
        }
    }

    public void updateLight() {
        int val = this.worldObj.getBlockLightValue(this.xCoord, this.yCoord, this.zCoord);
        if (this.lastLight != val) {
            this.lastLight = val;
            Platform.notifyBlocksOfNeighbors(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }
}

