/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.api.storage.IMEInventory;
import appeng.core.AELog;
import appeng.me.storage.MEIInventoryWrapper;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.iterators.InvIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AppEngInternalInventory
implements IInventory,
Iterable<ItemStack> {
    private final int size;
    private final ItemStack[] inv;
    private boolean enableClientEvents = false;
    private IAEAppEngInventory te;
    private int maxStack;

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size) {
        this.setTileEntity(inventory);
        this.size = size;
        this.maxStack = 64;
        this.inv = new ItemStack[size];
    }

    public IMEInventory getMEInventory() {
        return new MEIInventoryWrapper(this, null);
    }

    public boolean isEmpty() {
        for (int x = 0; x < this.size; ++x) {
            if (this.getStackInSlot(x) == null) continue;
            return false;
        }
        return true;
    }

    public int getSizeInventory() {
        return this.size;
    }

    public ItemStack getStackInSlot(int var1) {
        return this.inv[var1];
    }

    public ItemStack decrStackSize(int slot, int qty) {
        if (this.inv[slot] != null) {
            ItemStack split = this.getStackInSlot(slot);
            ItemStack ns = null;
            if (qty >= split.stackSize) {
                ns = this.inv[slot];
                this.inv[slot] = null;
            } else {
                ns = split.splitStack(qty);
            }
            if (this.getTileEntity() != null && this.eventsEnabled()) {
                this.getTileEntity().onChangeInventory(this, slot, InvOperation.decreaseStackSize, ns, null);
            }
            this.markDirty();
            return ns;
        }
        return null;
    }

    protected boolean eventsEnabled() {
        return Platform.isServer() || this.isEnableClientEvents();
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack newItemStack) {
        ItemStack oldStack = this.inv[slot];
        this.inv[slot] = newItemStack;
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            ItemStack removed = oldStack;
            ItemStack added = newItemStack;
            if (oldStack != null && newItemStack != null && Platform.isSameItem(oldStack, newItemStack)) {
                if (oldStack.stackSize > newItemStack.stackSize) {
                    removed = removed.copy();
                    removed.stackSize -= newItemStack.stackSize;
                    added = null;
                } else if (oldStack.stackSize < newItemStack.stackSize) {
                    added = added.copy();
                    added.stackSize -= oldStack.stackSize;
                    removed = null;
                } else {
                    added = null;
                    removed = null;
                }
            }
            this.getTileEntity().onChangeInventory(this, slot, InvOperation.setInventorySlotContents, removed, added);
            this.markDirty();
        }
    }

    public String getInventoryName() {
        return "appeng-internal";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return this.maxStack > 64 ? 64 : this.maxStack;
    }

    public void markDirty() {
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            this.getTileEntity().onChangeInventory(this, -1, InvOperation.markDirty, null, null);
        }
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public void setMaxStackSize(int s) {
        this.maxStack = s;
    }

    public void markDirty(int slotIndex) {
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            this.getTileEntity().onChangeInventory(this, slotIndex, InvOperation.markDirty, null, null);
        }
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = new NBTTagCompound();
        this.writeToNBT(c);
        data.setTag(name, (NBTBase)c);
    }

    private void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.inv[x] != null) {
                    this.inv[x].writeToNBT(c);
                }
                target.setTag("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.getCompoundTag(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    public void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = target.getCompoundTag("#" + x);
                if (c == null) continue;
                this.inv[x] = ItemStack.loadItemStackFromNBT((NBTTagCompound)c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new InvIterator(this);
    }

    private boolean isEnableClientEvents() {
        return this.enableClientEvents;
    }

    public void setEnableClientEvents(boolean enableClientEvents) {
        this.enableClientEvents = enableClientEvents;
    }

    private IAEAppEngInventory getTileEntity() {
        return this.te;
    }

    public void setTileEntity(IAEAppEngInventory te) {
        this.te = te;
    }
}

