/*
 * Decompiled with CFR 0.152.
 */
package appeng.server;

import appeng.api.parts.CableRenderMode;
import appeng.block.AEBaseBlock;
import appeng.client.EffectType;
import appeng.core.CommonHelper;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.items.tools.ToolNetworkTool;
import appeng.util.Platform;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ServerHelper
extends CommonHelper {
    private EntityPlayer renderModeBased;

    @Override
    public void init() {
    }

    @Override
    public World getWorld() {
        throw new UnsupportedOperationException("This is a server...");
    }

    @Override
    public void bindTileEntitySpecialRenderer(Class tile, AEBaseBlock blk) {
        throw new UnsupportedOperationException("This is a server...");
    }

    @Override
    public List<EntityPlayer> getPlayers() {
        MinecraftServer server;
        if (!Platform.isClient() && (server = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
            return server.getConfigurationManager().playerEntityList;
        }
        return new ArrayList<EntityPlayer>();
    }

    @Override
    public void sendToAllNearExcept(EntityPlayer p, double x, double y, double z, double dist, World w, AppEngPacket packet) {
        if (Platform.isClient()) {
            return;
        }
        for (EntityPlayer o : this.getPlayers()) {
            double dZ;
            double dY;
            double dX;
            EntityPlayerMP entityplayermp = (EntityPlayerMP)o;
            if (entityplayermp == p || entityplayermp.worldObj != w || !((dX = x - entityplayermp.posX) * dX + (dY = y - entityplayermp.posY) * dY + (dZ = z - entityplayermp.posZ) * dZ < dist * dist)) continue;
            NetworkHandler.instance.sendTo(packet, entityplayermp);
        }
    }

    @Override
    public void spawnEffect(EffectType type, World worldObj, double posX, double posY, double posZ, Object o) {
    }

    @Override
    public boolean shouldAddParticles(Random r) {
        return false;
    }

    @Override
    public MovingObjectPosition getMOP() {
        return null;
    }

    @Override
    public void doRenderItem(ItemStack sis, World tile) {
    }

    @Override
    public void postInit() {
    }

    @Override
    public CableRenderMode getRenderMode() {
        if (this.renderModeBased == null) {
            return CableRenderMode.Standard;
        }
        return this.renderModeForPlayer(this.renderModeBased);
    }

    protected CableRenderMode renderModeForPlayer(EntityPlayer player) {
        if (player != null) {
            for (int x = 0; x < InventoryPlayer.getHotbarSize(); ++x) {
                NBTTagCompound c;
                ItemStack is = player.inventory.getStackInSlot(x);
                if (is == null || !(is.getItem() instanceof ToolNetworkTool) || (c = is.getTagCompound()) == null || !c.getBoolean("hideFacades")) continue;
                return CableRenderMode.CableView;
            }
        }
        return CableRenderMode.Standard;
    }

    @Override
    public void triggerUpdates() {
    }

    @Override
    public void updateRenderMode(EntityPlayer player) {
        this.renderModeBased = player;
    }

    @Override
    public void missingCoreMod() {
        throw new IllegalStateException("Unable to Load Core Mod, please verify that AE2 is properly install in the mods folder, with a .jar extension.");
    }
}

