/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class PartP2PLight
extends PartP2PTunnel<PartP2PLight>
implements IGridTickable {
    private int lastValue = 0;
    private float opacity = -1.0f;

    public PartP2PLight(ItemStack is) {
        super(is);
    }

    @Override
    public void chanRender(MENetworkChannelsChanged c) {
        this.onTunnelNetworkChange();
        super.chanRender(c);
    }

    @Override
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onTunnelNetworkChange();
        super.powerRender(c);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.isOutput() ? this.lastValue : 0);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.lastValue = data.readInt();
        this.setOutput(this.lastValue > 0);
        return false;
    }

    private boolean doWork() {
        if (this.isOutput()) {
            return false;
        }
        TileEntity te = this.getTile();
        World w = te.getWorldObj();
        int newLevel = w.getBlockLightValue(te.xCoord + this.getSide().offsetX, te.yCoord + this.getSide().offsetY, te.zCoord + this.getSide().offsetZ);
        if (this.lastValue != newLevel && this.getProxy().isActive()) {
            this.lastValue = newLevel;
            try {
                for (PartP2PLight out : this.getOutputs()) {
                    out.setLightLevel(this.lastValue);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborChanged() {
        this.opacity = -1.0f;
        this.doWork();
        if (this.isOutput()) {
            this.getHost().markForUpdate();
        }
    }

    @Override
    public int getLightLevel() {
        if (this.isOutput() && this.isPowered()) {
            return this.blockLight(this.lastValue);
        }
        return 0;
    }

    private void setLightLevel(int out) {
        this.lastValue = out;
        this.getHost().markForUpdate();
    }

    private int blockLight(int emit) {
        if (this.opacity < 0.0f) {
            TileEntity te = this.getTile();
            this.opacity = 255 - te.getWorldObj().getBlockLightOpacity(te.xCoord + this.getSide().offsetX, te.yCoord + this.getSide().offsetY, te.zCoord + this.getSide().offsetZ);
        }
        return (int)((float)emit * (this.opacity / 255.0f));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.quartz_block.getBlockTextureFromSide(0);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("opacity")) {
            this.opacity = tag.getFloat("opacity");
        }
        this.lastValue = tag.getInteger("lastValue");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setFloat("opacity", this.opacity);
        tag.setInteger("lastValue", this.lastValue);
    }

    @Override
    public void onTunnelConfigChange() {
        this.onTunnelNetworkChange();
    }

    @Override
    public void onTunnelNetworkChange() {
        if (this.isOutput()) {
            PartP2PLight src = (PartP2PLight)this.getInput();
            if (src != null && src.getProxy().isActive()) {
                this.setLightLevel(src.lastValue);
            } else {
                this.getHost().markForUpdate();
            }
        } else {
            this.doWork();
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.LightTunnel.getMin(), TickRates.LightTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doWork() ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }
}

