/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;

public final class StorageMonitorWailaDataProvider
extends BasePartWailaDataProvider {
    @Override
    public List<String> getWailaBody(IPart part, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (part instanceof IPartStorageMonitor) {
            IPartStorageMonitor monitor = (IPartStorageMonitor)part;
            IAEStack<?> displayed = monitor.getDisplayed();
            boolean isLocked = monitor.isLocked();
            if (displayed instanceof IAEItemStack) {
                IAEItemStack ais = (IAEItemStack)displayed;
                currentToolTip.add(WailaText.Showing.getLocal() + ": " + ais.getItemStack().getDisplayName());
            } else if (displayed instanceof IAEFluidStack) {
                IAEFluidStack ais = (IAEFluidStack)displayed;
                currentToolTip.add(WailaText.Showing.getLocal() + ": " + ais.getFluid().getLocalizedName(ais.getFluidStack()));
            }
            currentToolTip.add(isLocked ? WailaText.Locked.getLocal() : WailaText.Unlocked.getLocal());
        }
        return currentToolTip;
    }
}

