/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.util.WorldCoord;
import appeng.client.texture.MissingIcon;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ToolEraser
extends AEBaseItem {
    private static final int BLOCK_ERASE_LIMIT = 90000;

    public ToolEraser() {
        this.setFeature(EnumSet.of(AEFeature.UnsupportedDeveloperTools, AEFeature.Creative));
    }

    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = new MissingIcon(this);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)stack, (int)1) <= 0) {
            return true;
        }
        if (Platform.isClient()) {
            return false;
        }
        Block blk = world.getBlock(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        if (blk != null && ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)side, (World)world).isCanceled()) {
            return true;
        }
        LinkedList<WorldCoord> next = new LinkedList<WorldCoord>();
        next.add(new WorldCoord(x, y, z));
        int blocks = 0;
        while (blocks < 90000 && !next.isEmpty()) {
            LinkedList<WorldCoord> c = next;
            next = new LinkedList();
            for (WorldCoord wc : c) {
                Block c_blk = world.getBlock(wc.x, wc.y, wc.z);
                int c_meta = world.getBlockMetadata(wc.x, wc.y, wc.z);
                if (c_blk != blk || c_meta != meta) continue;
                ++blocks;
                world.setBlock(wc.x, wc.y, wc.z, Platform.AIR_BLOCK);
                this.wrappedAdd(world, wc.x + 1, wc.y, wc.z, next);
                this.wrappedAdd(world, wc.x - 1, wc.y, wc.z, next);
                this.wrappedAdd(world, wc.x, wc.y + 1, wc.z, next);
                this.wrappedAdd(world, wc.x, wc.y - 1, wc.z, next);
                this.wrappedAdd(world, wc.x, wc.y, wc.z + 1, next);
                this.wrappedAdd(world, wc.x, wc.y, wc.z - 1, next);
            }
        }
        AELog.info("Delete " + blocks + " blocks", new Object[0]);
        return true;
    }

    private void wrappedAdd(World world, int i, int y, int z, Collection<WorldCoord> next) {
        next.add(new WorldCoord(i, y, z));
    }
}

