/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ItemViewCell;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class SlotCraftingTerm
extends AppEngCraftingSlot {
    private final IInventory craftInv;
    private final IInventory pattern;
    private final BaseActionSource mySrc;
    private final IEnergySource energySrc;
    private final IStorageMonitorable storage;
    private final IContainerCraftingPacket container;

    public SlotCraftingTerm(EntityPlayer player, BaseActionSource mySrc, IEnergySource energySrc, IStorageMonitorable storage, IInventory cMatrix, IInventory secondMatrix, IInventory output, int x, int y, IContainerCraftingPacket ccp) {
        super(player, cMatrix, output, 0, x, y);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.container = ccp;
    }

    public IInventory getCraftingMatrix() {
        return this.craftInv;
    }

    @Override
    public boolean canTakeStack(EntityPlayer par1EntityPlayer) {
        return false;
    }

    @Override
    public void onPickupFromSlot(EntityPlayer p, ItemStack is) {
    }

    public void doClick(InventoryAction action, EntityPlayer who) {
        if (this.getStack() == null) {
            return;
        }
        if (Platform.isClient()) {
            return;
        }
        IMEMonitor<IAEItemStack> inv = this.storage.getItemInventory();
        int howManyPerCraft = this.getStack().stackSize;
        int maxTimesToCraft = 0;
        InventoryAdaptor ia = null;
        if (action == InventoryAction.CRAFT_SHIFT) {
            ia = InventoryAdaptor.getAdaptor(who, null);
            maxTimesToCraft = (int)Math.floor((double)this.getStack().getMaxStackSize() / (double)howManyPerCraft);
        } else if (action == InventoryAction.CRAFT_STACK) {
            ia = new AdaptorPlayerHand(who);
            maxTimesToCraft = (int)Math.floor((double)this.getStack().getMaxStackSize() / (double)howManyPerCraft);
        } else {
            ia = new AdaptorPlayerHand(who);
            maxTimesToCraft = 1;
        }
        maxTimesToCraft = this.capCraftingAttempts(maxTimesToCraft);
        if (ia == null) {
            return;
        }
        ItemStack rs = Platform.cloneItemStack(this.getStack());
        if (rs == null) {
            return;
        }
        for (int x = 0; x < maxTimesToCraft; ++x) {
            IItemList<IAEItemStack> all;
            ItemStack extra;
            if (ia.simulateAdd(rs) != null || (extra = ia.addItems(this.craftItem(who, rs, inv, all = inv.getStorageList()))) == null) continue;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(extra);
            Platform.spawnDrops(who.worldObj, (int)who.posX, (int)who.posY, (int)who.posZ, drops);
            return;
        }
    }

    private int capCraftingAttempts(int maxTimesToCraft) {
        return maxTimesToCraft;
    }

    private ItemStack craftItem(EntityPlayer p, ItemStack request, IMEMonitor<IAEItemStack> inv, IItemList all) {
        ItemStack is = this.getStack();
        if (is != null && Platform.isSameItem(request, is)) {
            ItemStack[] set = new ItemStack[this.getPattern().getSizeInventory()];
            if (Platform.isServer()) {
                InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
                for (int x = 0; x < 9; ++x) {
                    ic.setInventorySlotContents(x, this.getPattern().getStackInSlot(x));
                }
                IRecipe r = Platform.findMatchingRecipe(ic, p.worldObj);
                if (r == null) {
                    Item target = request.getItem();
                    if (target.isDamageable() && target.isRepairable()) {
                        boolean isBad = false;
                        for (int x = 0; x < ic.getSizeInventory(); ++x) {
                            ItemStack pis = ic.getStackInSlot(x);
                            if (pis == null || pis.getItem() == target) continue;
                            isBad = true;
                        }
                        if (!isBad) {
                            super.onPickupFromSlot(p, is);
                            p.openContainer.onCraftMatrixChanged(this.craftInv);
                            return request;
                        }
                    }
                    return null;
                }
                is = r.getCraftingResult(ic);
                if (inv != null) {
                    for (int x = 0; x < this.getPattern().getSizeInventory(); ++x) {
                        if (this.getPattern().getStackInSlot(x) == null) continue;
                        set[x] = Platform.extractItemsByRecipe(this.energySrc, this.mySrc, inv, p.worldObj, r, is, ic, this.getPattern().getStackInSlot(x), x, all, Actionable.MODULATE, ItemViewCell.createFilter(this.container.getViewCells()));
                        ic.setInventorySlotContents(x, set[x]);
                    }
                }
            }
            if (this.preCraft(p, inv, set, is)) {
                this.makeItem(p, is);
                this.postCraft(p, inv, set, is);
            }
            p.openContainer.onCraftMatrixChanged(this.craftInv);
            return is;
        }
        return null;
    }

    private boolean preCraft(EntityPlayer p, IMEMonitor<IAEItemStack> inv, ItemStack[] set, ItemStack result) {
        return true;
    }

    private void makeItem(EntityPlayer p, ItemStack is) {
        super.onPickupFromSlot(p, is);
    }

    private void postCraft(EntityPlayer p, IMEMonitor<IAEItemStack> inv, ItemStack[] set, ItemStack result) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (Platform.isServer()) {
            for (int x = 0; x < this.craftInv.getSizeInventory(); ++x) {
                IAEItemStack fail;
                if (this.craftInv.getStackInSlot(x) == null) {
                    this.craftInv.setInventorySlotContents(x, set[x]);
                    continue;
                }
                if (set[x] == null || (fail = (IAEItemStack)inv.injectItems(AEItemStack.create(set[x]), Actionable.MODULATE, this.mySrc)) == null) continue;
                drops.add(fail.getItemStack());
            }
        }
        if (drops.size() > 0) {
            Platform.spawnDrops(p.worldObj, (int)p.posX, (int)p.posY, (int)p.posZ, drops);
        }
    }

    IInventory getPattern() {
        return this.pattern;
    }
}

