/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.storage.BlockDrive;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.storage.TileDrive;
import appeng.util.Platform;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderDrive
extends BaseBlockRender<BlockDrive, TileDrive> {
    public RenderDrive() {
        super(false, 0.0);
    }

    @Override
    public void renderInventory(BlockDrive block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        renderer.overrideBlockTexture = ExtraBlockTextures.getMissing();
        this.renderInvBlock(EnumSet.of(ForgeDirection.SOUTH), block, is, Tessellator.instance, 0, renderer);
        renderer.overrideBlockTexture = null;
        super.renderInventory(block, is, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(BlockDrive imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TileDrive sp = (TileDrive)imb.getTileEntity(world, x, y, z);
        ForgeDirection up = sp.getUp();
        ForgeDirection forward = sp.getForward();
        ForgeDirection west = Platform.crossProduct(forward, up);
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        boolean result = super.renderInWorld(imb, world, x, y, z, renderer);
        Tessellator tess = Tessellator.instance;
        IIcon ico = ExtraBlockTextures.MEStorageCellTextures.getIcon();
        int b = world.getLightBrightnessForSkyBlocks(x + forward.offsetX, y + forward.offsetY, z + forward.offsetZ, 0);
        for (int yy = 0; yy < 5; ++yy) {
            block61: for (int xx = 0; xx < 2; ++xx) {
                int stat = sp.getCellStatus(yy * 2 + (1 - xx));
                this.selectFace(renderer, west, up, forward, 2 + xx * 7, 7 + xx * 7, 1 + yy * 3, 3 + yy * 3);
                int spin = 0;
                block0 : switch (forward.offsetX + forward.offsetY * 2 + forward.offsetZ * 3) {
                    case 1: {
                        switch (up) {
                            case UP: {
                                spin = 3;
                                break block0;
                            }
                            case DOWN: {
                                spin = 1;
                                break block0;
                            }
                            case NORTH: {
                                spin = 0;
                                break block0;
                            }
                            case SOUTH: {
                                spin = 2;
                                break block0;
                            }
                        }
                        break;
                    }
                    case -1: {
                        switch (up) {
                            case UP: {
                                spin = 1;
                                break block0;
                            }
                            case DOWN: {
                                spin = 3;
                                break block0;
                            }
                            case NORTH: {
                                spin = 0;
                                break block0;
                            }
                            case SOUTH: {
                                spin = 2;
                                break block0;
                            }
                        }
                        break;
                    }
                    case -2: {
                        switch (up) {
                            case EAST: {
                                spin = 1;
                                break block0;
                            }
                            case WEST: {
                                spin = 3;
                                break block0;
                            }
                            case NORTH: {
                                spin = 2;
                                break block0;
                            }
                            case SOUTH: {
                                spin = 0;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (up) {
                            case EAST: {
                                spin = 1;
                                break block0;
                            }
                            case WEST: {
                                spin = 3;
                                break block0;
                            }
                            case NORTH: {
                                spin = 0;
                                break block0;
                            }
                            case SOUTH: {
                                spin = 0;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (up) {
                            case UP: {
                                spin = 2;
                                break block0;
                            }
                            case DOWN: {
                                spin = 0;
                                break block0;
                            }
                            case EAST: {
                                spin = 3;
                                break block0;
                            }
                            case WEST: {
                                spin = 1;
                                break block0;
                            }
                        }
                        break;
                    }
                    case -3: {
                        switch (up) {
                            case UP: {
                                spin = 2;
                                break block0;
                            }
                            case DOWN: {
                                spin = 0;
                                break block0;
                            }
                            case EAST: {
                                spin = 1;
                                break block0;
                            }
                            case WEST: {
                                spin = 3;
                                break block0;
                            }
                        }
                    }
                }
                double u1 = ico.getInterpolatedU(spin % 4 < 2 ? 1.0 : 6.0);
                double u2 = ico.getInterpolatedU((spin + 1) % 4 < 2 ? 1.0 : 6.0);
                double u3 = ico.getInterpolatedU((spin + 2) % 4 < 2 ? 1.0 : 6.0);
                double u4 = ico.getInterpolatedU((spin + 3) % 4 < 2 ? 1.0 : 6.0);
                int m = 1;
                int mx = 3;
                if (stat == 0) {
                    m = 4;
                    mx = 5;
                }
                double v1 = ico.getInterpolatedV((spin + 1) % 4 < 2 ? (double)m : (double)mx);
                double v2 = ico.getInterpolatedV((spin + 2) % 4 < 2 ? (double)m : (double)mx);
                double v3 = ico.getInterpolatedV((spin + 3) % 4 < 2 ? (double)m : (double)mx);
                double v4 = ico.getInterpolatedV(spin % 4 < 2 ? (double)m : (double)mx);
                tess.setBrightness(b);
                tess.setColorOpaque_I(0xFFFFFF);
                switch (forward.offsetX + forward.offsetY * 2 + forward.offsetZ * 3) {
                    case 1: {
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMinZ, u4, v4);
                        break;
                    }
                    case -1: {
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMinZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u4, v4);
                        break;
                    }
                    case -2: {
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u4, v4);
                        break;
                    }
                    case 2: {
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u4, v4);
                        break;
                    }
                    case 3: {
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u4, v4);
                        break;
                    }
                    case -3: {
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u4, v4);
                    }
                }
                if (forward == ForgeDirection.UP && up == ForgeDirection.SOUTH || forward == ForgeDirection.DOWN) {
                    this.selectFace(renderer, west, up, forward, 3 + xx * 7, 4 + xx * 7, 1 + yy * 3, 2 + yy * 3);
                } else {
                    this.selectFace(renderer, west, up, forward, 5 + xx * 7, 6 + xx * 7, 2 + yy * 3, 3 + yy * 3);
                }
                if (stat == 0) continue;
                IIcon whiteIcon = ExtraBlockTextures.White.getIcon();
                u1 = whiteIcon.getInterpolatedU(spin % 4 < 2 ? 1.0 : 6.0);
                u2 = whiteIcon.getInterpolatedU((spin + 1) % 4 < 2 ? 1.0 : 6.0);
                u3 = whiteIcon.getInterpolatedU((spin + 2) % 4 < 2 ? 1.0 : 6.0);
                u4 = whiteIcon.getInterpolatedU((spin + 3) % 4 < 2 ? 1.0 : 6.0);
                v1 = whiteIcon.getInterpolatedV((spin + 1) % 4 < 2 ? 1.0 : 3.0);
                v2 = whiteIcon.getInterpolatedV((spin + 2) % 4 < 2 ? 1.0 : 3.0);
                v3 = whiteIcon.getInterpolatedV((spin + 3) % 4 < 2 ? 1.0 : 3.0);
                v4 = whiteIcon.getInterpolatedV(spin % 4 < 2 ? 1.0 : 3.0);
                if (sp.isPowered()) {
                    tess.setBrightness(0xF000F0);
                } else {
                    tess.setBrightness(0);
                }
                if (stat == 1) {
                    Tessellator.instance.setColorOpaque_I(65280);
                }
                if (stat == 2) {
                    Tessellator.instance.setColorOpaque_I(0xFFAA00);
                }
                if (stat == 3) {
                    Tessellator.instance.setColorOpaque_I(0xFF0000);
                }
                switch (forward.offsetX + forward.offsetY * 2 + forward.offsetZ * 3) {
                    case 1: {
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMinZ, u4, v4);
                        continue block61;
                    }
                    case -1: {
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMinZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u4, v4);
                        continue block61;
                    }
                    case -2: {
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u4, v4);
                        continue block61;
                    }
                    case 2: {
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMinZ, u4, v4);
                        continue block61;
                    }
                    case 3: {
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u4, v4);
                        continue block61;
                    }
                    case -3: {
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u1, v1);
                        tess.addVertexWithUV((double)x + renderer.renderMinX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u2, v2);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMaxY, (double)z + renderer.renderMaxZ, u3, v3);
                        tess.addVertexWithUV((double)x + renderer.renderMaxX, (double)y + renderer.renderMinY, (double)z + renderer.renderMaxZ, u4, v4);
                    }
                }
            }
        }
        renderer.overrideBlockTexture = null;
        return result;
    }
}

